/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.core;

import java.net.URLClassLoader;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.project.model.Module;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.shared.project.KieModule;

@ApplicationScoped
@Named(value="LRUModuleDependenciesClassLoaderCache")
public class LRUModuleDependenciesClassLoaderCache
extends LRUCache<KieModule, ClassLoader> {
    private BuildInfoService buildInfoService;

    public LRUModuleDependenciesClassLoaderCache() {
    }

    @Inject
    public LRUModuleDependenciesClassLoaderCache(BuildInfoService buildInfoService) {
        this.buildInfoService = buildInfoService;
    }

    protected void setBuildInfoService(BuildInfoService buildInfoService) {
        this.buildInfoService = buildInfoService;
    }

    public ClassLoader assertDependenciesClassLoader(KieModule module) {
        ClassLoader classLoader = (ClassLoader)this.getEntry(module);
        if (classLoader == null) {
            classLoader = this.buildClassLoader(module);
            this.setEntry(module, classLoader);
        }
        return classLoader;
    }

    public static ClassLoader buildClassLoader(KieModule module, KieModuleMetaData kieModuleMetaData) {
        ClassLoader classLoader = kieModuleMetaData.getClassLoader().getParent();
        if (classLoader instanceof URLClassLoader) {
            return classLoader;
        }
        throw new RuntimeException("It was not possible to calculate project dependencies class loader for project: " + module.getKModuleXMLPath());
    }

    public void setDependenciesClassLoader(KieModule module, ClassLoader classLoader) {
        this.setEntry(module, classLoader);
    }

    private ClassLoader buildClassLoader(KieModule module) {
        return LRUModuleDependenciesClassLoaderCache.buildClassLoader(module, KieModuleMetaData.Factory.newKieModuleMetaData((org.kie.api.builder.KieModule)this.buildInfoService.getBuildInfo((Module)module).getKieModuleIgnoringErrors()));
    }
}

