/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.editors.included;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class DMNImportTypes {
    private final String fileExtension;
    private final List<String> namespaces;
    private static final List<DMNImportTypes> importTypes = new ArrayList<DMNImportTypes>();
    public static final DMNImportTypes DMN = DMNImportTypes.registerImportType("dmn", "http://www.omg.org/spec/DMN/20180521/MODEL/");
    public static final DMNImportTypes PMML = DMNImportTypes.registerImportType("pmml", "http://www.dmg.org/PMML-3_0", "http://www.dmg.org/PMML-3_1", "http://www.dmg.org/PMML-3_2", "http://www.dmg.org/PMML-4_0", "http://www.dmg.org/PMML-4_1", "http://www.dmg.org/PMML-4_2", "http://www.dmg.org/PMML-4_3");

    private DMNImportTypes(String fileExtension, String ... namespaces) {
        this.fileExtension = fileExtension;
        this.namespaces = Arrays.asList(namespaces);
    }

    private static DMNImportTypes registerImportType(String fileExtension, String ... namespaces) {
        DMNImportTypes importType = new DMNImportTypes(fileExtension, namespaces);
        importTypes.add(importType);
        return importType;
    }

    public static DMNImportTypes determineImportType(String namespace) {
        return importTypes.stream().filter(importType -> importType.matchesNamespace(namespace)).findFirst().orElse(null);
    }

    private boolean matchesNamespace(String namespace) {
        return this.namespaces.stream().anyMatch(ns -> Objects.equals(ns, namespace));
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getDefaultNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }
}

