/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionId;
import org.kie.workbench.common.stunner.core.definition.clone.ClonePolicy;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.AddConnectorCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DeleteConnectorCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SetConnectionTargetNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.util.UUID;

@Portable
public final class CloneConnectorCommand
extends AbstractGraphCompositeCommand {
    private final Edge candidate;
    private transient Edge clone;
    private transient Connection sourceConnection;
    private transient Connection targetConnection;
    private transient Node<? extends View<?>, Edge> sourceNode;
    private transient Node<? extends View<?>, Edge> targetNode;
    private final String sourceNodeUUID;
    private final String targetNodeUUID;
    private final Optional<Consumer<Edge>> callback;

    public CloneConnectorCommand() {
        this(null, null, null);
    }

    public CloneConnectorCommand(@MapsTo(value="candidate") Edge candidate, @MapsTo(value="sourceNodeUUID") String sourceNodeUUID, @MapsTo(value="targetNodeUUID") String targetNodeUUID) {
        this(candidate, sourceNodeUUID, targetNodeUUID, null);
    }

    public CloneConnectorCommand(Edge candidate, String sourceNodeUUID, String targetNodeUUID, Consumer<Edge> callback) {
        this.candidate = (Edge)PortablePreconditions.checkNotNull((String)"candidate", (Object)candidate);
        this.sourceNodeUUID = (String)PortablePreconditions.checkNotNull((String)"sourceNodeUUID", (Object)sourceNodeUUID);
        this.targetNodeUUID = (String)PortablePreconditions.checkNotNull((String)"targetNodeUUID", (Object)targetNodeUUID);
        this.callback = Optional.ofNullable(callback);
    }

    protected CloneConnectorCommand initialize(GraphCommandExecutionContext context) {
        super.initialize(context);
        this.sourceNode = this.getNode(context, this.sourceNodeUUID);
        this.targetNode = this.getNode(context, this.targetNodeUUID);
        if (!(this.candidate.getContent() instanceof ViewConnector)) {
            throw new IllegalArgumentException("Candidate: " + this.candidate.getTargetNode() + " content should be a ViewConnector");
        }
        ViewConnector edgeContent = (ViewConnector)this.candidate.getContent();
        Object bean = edgeContent.getDefinition();
        DefinitionId definitionId = context.getDefinitionManager().adapters().forDefinition().getId(bean);
        this.clone = context.getFactoryManager().newElement(UUID.uuid(), definitionId.value()).asEdge();
        Object clonedDefinition = context.getDefinitionManager().cloneManager().clone(edgeContent.getDefinition(), ClonePolicy.ALL);
        ViewConnector clonedContent = (ViewConnector)this.clone.getContent();
        clonedContent.setDefinition(clonedDefinition);
        ViewConnector connectionContent = (ViewConnector)this.candidate.getContent();
        this.sourceConnection = connectionContent.getSourceConnection().orElse(null);
        this.targetConnection = connectionContent.getTargetConnection().orElse(null);
        this.commands.add(new AddConnectorCommand(this.sourceNode, this.clone, this.sourceConnection));
        this.commands.add(new SetConnectionTargetNodeCommand(this.targetNode, (Edge<? extends View, Node>)this.clone, this.targetConnection));
        this.getMutableIndex(context).addEdge(this.clone);
        return this;
    }

    @Override
    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        CommandResult commandResult = super.execute(context);
        if (!CommandUtils.isError(commandResult)) {
            this.callback.ifPresent(c -> c.accept(this.clone));
        }
        return commandResult;
    }

    @Override
    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        return new DeleteConnectorCommand((Edge<? extends View, Node>)this.clone).execute(context);
    }

    @Override
    protected boolean delegateRulesContextToChildren() {
        return true;
    }

    protected Edge getCandidate() {
        return this.candidate;
    }
}

