/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.context.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.rule.context.CardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.ConnectorCardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.EdgeCardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.ElementCardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.GraphConnectionContext;
import org.kie.workbench.common.stunner.core.rule.context.GraphEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.context.NodeContainmentContext;
import org.kie.workbench.common.stunner.core.rule.context.NodeDockingContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.StatefulGraphEvaluationState;

public class StatefulGraphEvaluationContexts {
    private static final Map<Class<? extends GraphEvaluationContext>, ContextConsumer<? extends GraphEvaluationContext>> CONSUMERS_BY_TYPE = new Maps.Builder().put(ElementCardinalityContext.class, (Object)new ElementCardinalityContextConsumer()).put(ConnectorCardinalityContext.class, (Object)new ConnectorCardinalityContextConsumer()).put(GraphConnectionContext.class, (Object)new ConnectionStateContextConsumer()).put(NodeContainmentContext.class, (Object)new ContainmentStateContextConsumer()).put(NodeDockingContext.class, (Object)new DockingStateContextConsumer()).build();

    public static <T> T evaluate(GraphEvaluationContext context, Function<GraphEvaluationContext, T> function) {
        T result = function.apply(context);
        StatefulGraphEvaluationContexts.consumeContextAndPopulateState(context, (StatefulGraphEvaluationState)context.getState());
        return result;
    }

    private static void consumeContextAndPopulateState(GraphEvaluationContext context, StatefulGraphEvaluationState state) {
        Class type = context.getType();
        ContextConsumer<? extends GraphEvaluationContext> contextConsumer = CONSUMERS_BY_TYPE.get(type);
        if (null == contextConsumer) {
            throw new IllegalStateException("No evaluation context consumer present for context [" + type.getName() + "]");
        }
        contextConsumer.consume(state, (GraphEvaluationContext)context);
    }

    private static boolean isIncoming(EdgeCardinalityContext.Direction direction) {
        return direction.equals((Object)EdgeCardinalityContext.Direction.INCOMING);
    }

    private static boolean isAdd(CardinalityContext.Operation operation) {
        return operation.equals((Object)CardinalityContext.Operation.ADD);
    }

    private static class DockingStateContextConsumer
    implements ContextConsumer<NodeDockingContext> {
        private DockingStateContextConsumer() {
        }

        @Override
        public void consume(StatefulGraphEvaluationState state, NodeDockingContext context) {
            StatefulGraphEvaluationState.StatefulDockingState dockingState = state.getDockingState();
            Node candidate = context.getCandidate();
            Element parent = context.getParent();
            dockingState.setDockedTo(candidate, parent);
        }
    }

    private static class ContainmentStateContextConsumer
    implements ContextConsumer<NodeContainmentContext> {
        private ContainmentStateContextConsumer() {
        }

        @Override
        public void consume(StatefulGraphEvaluationState state, NodeContainmentContext context) {
            StatefulGraphEvaluationState.StatefulContainmentState containmentState = state.getContainmentState();
            Element parent = context.getParent();
            Collection candidates = context.getCandidates();
            candidates.forEach(candidate -> containmentState.setParent((Node)candidate, parent));
        }
    }

    private static class ConnectionStateContextConsumer
    implements ContextConsumer<GraphConnectionContext> {
        private ConnectionStateContextConsumer() {
        }

        @Override
        public void consume(StatefulGraphEvaluationState state, GraphConnectionContext context) {
            StatefulGraphEvaluationState.StatefulConnectionState connectionState = state.getConnectionState();
            Edge connector = context.getConnector();
            Optional source = context.getSource();
            Optional target = context.getTarget();
            connectionState.setSourceNode(connector, source.orElse(null));
            connectionState.setTargetNode(connector, target.orElse(null));
        }
    }

    private static class ConnectorCardinalityContextConsumer
    implements ContextConsumer<ConnectorCardinalityContext> {
        private ConnectorCardinalityContextConsumer() {
        }

        @Override
        public void consume(StatefulGraphEvaluationState state, ConnectorCardinalityContext context) {
            StatefulGraphEvaluationState.StatefulConnectorCardinalityState connectorCardinalityState = state.getConnectorCardinalityState();
            Edge edge = context.getEdge();
            Element candidate = context.getCandidate();
            EdgeCardinalityContext.Direction direction = context.getDirection();
            Optional operation = context.getOperation();
            if (!operation.isPresent() || null == candidate.asNode()) {
                return;
            }
            Node node = (Node)candidate;
            if (StatefulGraphEvaluationContexts.isIncoming(direction)) {
                if (StatefulGraphEvaluationContexts.isAdd((CardinalityContext.Operation)operation.get())) {
                    connectorCardinalityState.addIncoming(node, edge);
                } else {
                    connectorCardinalityState.deleteIncoming(node, edge);
                }
            } else if (StatefulGraphEvaluationContexts.isAdd((CardinalityContext.Operation)operation.get())) {
                connectorCardinalityState.addOutgoing(node, edge);
            } else {
                connectorCardinalityState.deleteOutgoing(node, edge);
            }
        }
    }

    private static class ElementCardinalityContextConsumer
    implements ContextConsumer<ElementCardinalityContext> {
        private ElementCardinalityContextConsumer() {
        }

        @Override
        public void consume(StatefulGraphEvaluationState state, ElementCardinalityContext context) {
            StatefulGraphEvaluationState.StatefulCardinalityState cardinalityState = state.getCardinalityState();
            Optional operation = context.getOperation();
            Collection candidates = context.getCandidates();
            if (operation.isPresent()) {
                boolean isAdd = StatefulGraphEvaluationContexts.isAdd((CardinalityContext.Operation)operation.get());
                Consumer<Element> addORDeleteIt = candidate -> {
                    if (isAdd) {
                        cardinalityState.add((Element<? extends View<?>>)candidate);
                    } else {
                        cardinalityState.delete((Element<? extends View<?>>)candidate);
                    }
                };
                candidates.forEach(addORDeleteIt::accept);
            }
        }
    }

    private static interface ContextConsumer<C extends GraphEvaluationContext> {
        public void consume(StatefulGraphEvaluationState var1, C var2);
    }
}

