/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.prometheus.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.dashbuilder.dataprovider.prometheus.client.HttpClient;
import org.dashbuilder.dataprovider.prometheus.client.PrometheusCredentialProvider;
import org.dashbuilder.dataprovider.prometheus.client.QueryResponse;
import org.dashbuilder.dataprovider.prometheus.client.QueryResponseParser;

public class PrometheusClient {
    private static final String DEFAULT_BASE_URL = "http://localhost:9090";
    private static final String API_BASE_URI = "api/v1";
    private static final String QUERY_URL = "api/v1/query";
    private static final String QUERY_RANGE_URI = "api/v1/query_range";
    private static final String QUERY_PARAM = "query";
    private static final String START_PARAM = "start";
    private static final String END_PARAM = "end";
    private static final String STEP_PARAM = "step";
    private String baseUrl = "http://localhost:9090";
    private HttpClient client;
    private QueryResponseParser parser;

    public PrometheusClient() {
        this(DEFAULT_BASE_URL);
    }

    public PrometheusClient(String baseUrl) {
        this(baseUrl, HttpClient.get(), QueryResponseParser.get());
    }

    PrometheusClient(String baseUrl, HttpClient client, QueryResponseParser parser) {
        this.baseUrl = baseUrl;
        this.client = client;
        this.parser = parser;
    }

    public QueryResponse query(String query) {
        String url = this.buildUrl(QUERY_URL, query, null, null, null);
        return this.getQueryResponse(url);
    }

    public QueryResponse queryRange(String query, String start, String end, String step) {
        String url = this.buildUrl(QUERY_RANGE_URI, query, start, end, step);
        return this.getQueryResponse(url);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    String buildUrl(String base, String query, String start, String end, String step) {
        String url = this.removeLastSlash();
        String apiUrl = String.join((CharSequence)"/", url, base) + "?";
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParam(params, QUERY_PARAM, query);
        this.addParam(params, START_PARAM, start);
        this.addParam(params, END_PARAM, end);
        this.addParam(params, STEP_PARAM, step);
        return params.entrySet().stream().map(e -> (String)e.getKey() + "=" + this.encodeValue((String)e.getValue())).collect(Collectors.joining("&", apiUrl, ""));
    }

    private String removeLastSlash() {
        return this.baseUrl.endsWith("/") ? this.baseUrl.substring(0, this.baseUrl.length() - 1) : this.baseUrl;
    }

    private void addParam(Map<String, String> params, String paramName, String paramValue) {
        if (paramValue != null) {
            params.put(paramName, paramValue);
        }
    }

    private String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding value " + value, e);
        }
    }

    private QueryResponse getQueryResponse(String url) {
        PrometheusCredentialProvider credentialProvider = PrometheusCredentialProvider.get();
        String username = credentialProvider.getUser();
        String password = credentialProvider.getPassword();
        return this.parser.parse(this.client.doGet(url, username, password));
    }
}

