/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.service.impl.documents.storage;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.kie.workbench.common.forms.jbpm.model.document.DocumentData;
import org.kie.workbench.common.forms.jbpm.server.service.impl.documents.DocumentUploadSession;
import org.kie.workbench.common.forms.jbpm.server.service.impl.documents.storage.UploadedDocumentStorage;
import org.kie.workbench.common.forms.jbpm.service.shared.documents.DocumentUploadChunk;
import org.uberfire.server.BaseUploadServlet;

@WebServlet(name="FormsDocumentServlet", urlPatterns={"/documentUploadServlet"})
public class FormsDocumentServlet
extends BaseUploadServlet {
    @Inject
    protected UploadedDocumentStorage storage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            FileItem fileItem = this.getFileItem(req);
            String id = UUID.randomUUID().toString();
            String content = Base64.getEncoder().encodeToString(fileItem.get());
            DocumentUploadChunk chunk = new DocumentUploadChunk(id, fileItem.getName(), 0, 1, content);
            DocumentUploadSession session = new DocumentUploadSession(chunk.getDocumentId(), chunk.getDocumentName(), chunk.getMaxChunks());
            session.add(chunk);
            this.storage.uploadContentChunk(chunk);
            session.setState(DocumentUploadSession.State.MERGING);
            this.storage.merge(session);
            DocumentData data = new DocumentData(id, fileItem.getName(), fileItem.getSize(), "", System.currentTimeMillis());
            response.put("document", data);
        }
        catch (Exception e) {
            response.put("error", "error");
        }
        finally {
            this.writeResponse(resp, response);
        }
    }

    protected void writeResponse(HttpServletResponse response, Map<String, Object> uploadResponse) throws IOException {
        Gson gson = new Gson();
        response.setContentType("text/html");
        response.getWriter().write(gson.toJson(uploadResponse));
        response.getWriter().flush();
    }
}

