/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.definition.adapter.reflect;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.AbstractReflectAdapter;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.ReflectionAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionId;
import org.kie.workbench.common.stunner.core.definition.adapter.HasInheritance;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.annotation.Definition;
import org.kie.workbench.common.stunner.core.definition.annotation.Description;
import org.kie.workbench.common.stunner.core.definition.annotation.Property;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Category;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Id;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Labels;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Title;
import org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class BackendDefinitionAdapter<T>
extends AbstractReflectAdapter<T>
implements DefinitionAdapter<T>,
HasInheritance {
    private static final Logger LOG = LoggerFactory.getLogger(BackendDefinitionAdapter.class);
    private static final Class[] DEF_ANNOTATIONS = new Class[]{Title.class, Category.class, Description.class, Property.class};

    @Inject
    public BackendDefinitionAdapter() {
    }

    public boolean accepts(Class<?> pojo) {
        return pojo.getAnnotation(Definition.class) != null;
    }

    public DefinitionId getId(T definition) {
        String definitionId = BackendDefinitionAdapter.getDefinitionId(definition.getClass());
        Id idAnn = BackendDefinitionAdapter.getClassAnnotation(definition.getClass(), Id.class);
        if (null != idAnn) {
            try {
                String value = BindableAdapterUtils.getDynamicDefinitionId((String)definitionId, (String)((String)this.getAnnotatedFieldValue(definition, Id.class)));
                return DefinitionId.build((String)value, (int)definitionId.length());
            }
            catch (Exception e) {
                LOG.error("Error obtaining annotated id for Definition " + definition.getClass().getName());
            }
        }
        return DefinitionId.build((String)definitionId);
    }

    public String[] getPropertyFields(T pojo) {
        List<String> fields = BackendDefinitionAdapter.visitFields(pojo.getClass(), field -> null != field.getAnnotation(Property.class));
        return fields.toArray(new String[fields.size()]);
    }

    private static List<String> visitFields(Class<?> type, Predicate<Field> fieldAcceptor) {
        ArrayList<String> result = new ArrayList<String>();
        BackendDefinitionAdapter.visitFields(type, "", fieldAcceptor, result, new HashSet<String>());
        return result;
    }

    private static void visitFields(Class<?> type, String namespace, Predicate<Field> fieldAcceptor, List<String> result, Set<String> processedTypes) {
        String fqcn = type.getName();
        if (ClassUtils.isJavaRuntimeClassname((String)fqcn) || processedTypes.contains(fqcn)) {
            return;
        }
        processedTypes.add(fqcn);
        List<Field> fields = ReflectionAdapterUtils.getFields(type);
        fields.forEach(field -> {
            String fieldName = field.getName();
            String absoluteFieldName = BackendDefinitionAdapter.appendToNamespace(namespace, fieldName);
            if (fieldAcceptor.test((Field)field)) {
                ArrayList<String> result1 = new ArrayList<String>();
                Class<?> fieldType = field.getType();
                BackendDefinitionAdapter.visitFields(fieldType, absoluteFieldName, fieldAcceptor, result1, processedTypes);
                if (result1.isEmpty()) {
                    result.add(absoluteFieldName);
                } else {
                    result.addAll(result1);
                }
            }
        });
    }

    private static String appendToNamespace(String namespace, String field) {
        return namespace.trim().length() > 0 ? namespace + "." + field : field;
    }

    private static boolean isPropertyOfMetaType(Field field, PropertyMetaTypes metaType) {
        Property annotation = field.getAnnotation(Property.class);
        if (null != annotation) {
            PropertyMetaTypes type = annotation.meta();
            return metaType.equals((Object)type);
        }
        return false;
    }

    public String getMetaPropertyField(T pojo, PropertyMetaTypes metaType) {
        List<String> fields = BackendDefinitionAdapter.visitFields(pojo.getClass(), field -> BackendDefinitionAdapter.isPropertyOfMetaType(field, metaType));
        return !fields.isEmpty() ? fields.get(0) : null;
    }

    public String getCategory(T definition) {
        try {
            return (String)this.getAnnotatedFieldValue(definition, Category.class);
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated category for Definition with id " + this.getId(definition));
            return null;
        }
    }

    public String getTitle(T definition) {
        try {
            return (String)this.getAnnotatedFieldValue(definition, Title.class);
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated title for Definition with id " + this.getId(definition));
            return BindableAdapterUtils.toSimpleName(definition);
        }
    }

    public String getDescription(T definition) {
        try {
            return (String)this.getAnnotatedFieldValue(definition, Description.class);
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated description for Definition with id " + this.getId(definition));
            return BindableAdapterUtils.toSimpleName(definition);
        }
    }

    public String[] getLabels(T definition) {
        try {
            Object value = this.getAnnotatedFieldValue(definition, Labels.class);
            if (value instanceof Collection) {
                return ((Collection)value).toArray(new String[((Collection)value).size()]);
            }
            return null != value ? (String[])value : new String[]{};
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated labels for Definition with id " + this.getId(definition));
            return new String[0];
        }
    }

    public Class<? extends ElementFactory> getGraphFactoryType(T definition) {
        Definition annotation = BackendDefinitionAdapter.getDefinitionAnnotation(definition.getClass());
        return null != annotation ? annotation.graphFactory() : null;
    }

    public static Class<? extends ElementFactory> getGraphFactory(Class<?> type) {
        Definition annotation = BackendDefinitionAdapter.getDefinitionAnnotation(type);
        return null != annotation ? annotation.graphFactory() : null;
    }

    protected static Definition getDefinitionAnnotation(Class<?> type) {
        if (null != type) {
            Definition annotation = BackendDefinitionAdapter.getClassAnnotation(type, Definition.class);
            return annotation;
        }
        return null;
    }

    public String getBaseType(Class<?> type) {
        return Optional.ofNullable(type).filter(t -> !t.isPrimitive()).filter(t -> Objects.nonNull(BackendDefinitionAdapter.getClassAnnotation(t, Definition.class))).map(this::findBaseParent).map(AbstractReflectAdapter::getDefinitionId).orElse(null);
    }

    private Class findBaseParent(Class type) {
        return Objects.isNull(type) || Object.class.equals((Object)type) ? null : Optional.ofNullable(type).map(Class::getSuperclass).filter(this::isBaseType).orElse(this.findBaseParent(type.getSuperclass()));
    }

    public String[] getTypes(String baseType) {
        throw new UnsupportedOperationException("Not implemented yet. Must keep some collection for this. ");
    }

    private boolean isBaseType(Class<?> type) {
        Field[] fields;
        for (Field field : fields = type.getDeclaredFields()) {
            for (Class a : DEF_ANNOTATIONS) {
                Object annotation = field.getAnnotation(a);
                if (null == annotation) continue;
                return true;
            }
        }
        return false;
    }
}

