/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.definition.adapter.reflect;

import java.lang.reflect.Field;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.AbstractReflectAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.PropertyAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.annotation.Property;
import org.kie.workbench.common.stunner.core.definition.annotation.property.Caption;
import org.kie.workbench.common.stunner.core.definition.annotation.property.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class BackendPropertyAdapter<T>
extends AbstractReflectAdapter<T>
implements PropertyAdapter<T, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(BackendPropertyAdapter.class);

    public String getId(T property) {
        return BindableAdapterUtils.getPropertyId(property.getClass());
    }

    public String getCaption(T property) {
        try {
            return (String)this.getAnnotatedFieldValue(property, Caption.class);
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated category for Property with id " + this.getId(property));
            return null;
        }
    }

    public Object getValue(T property) {
        if (null != property) {
            Class<Object> c = property.getClass();
            while (!c.isAssignableFrom(Object.class)) {
                Field[] fields;
                for (Field field : fields = c.getDeclaredFields()) {
                    Value annotation = field.getAnnotation(Value.class);
                    if (null == annotation) continue;
                    try {
                        return this._getValue(field, annotation, property);
                    }
                    catch (Exception e) {
                        LOG.error("Error obtaining annotated value for Property with id " + this.getId(property), (Throwable)e);
                    }
                }
                c = c.getSuperclass();
            }
        }
        return null;
    }

    private <V> V _getValue(Field field, Object annotation, T property) throws IllegalAccessException {
        if (null != annotation) {
            field.setAccessible(true);
            return (V)field.get(property);
        }
        return null;
    }

    public void setValue(T property, Object value) {
        if (null != property) {
            Class<Object> c = property.getClass();
            boolean done = false;
            while (!done && !c.isAssignableFrom(Object.class)) {
                Field[] fields;
                for (Field field : fields = c.getDeclaredFields()) {
                    Value annotation = field.getAnnotation(Value.class);
                    if (null == annotation) continue;
                    try {
                        field.setAccessible(true);
                        field.set(property, value);
                        done = true;
                        break;
                    }
                    catch (Exception e) {
                        LOG.error("Error setting value for Property with id [" + this.getId(property) + "] and value [" + (value != null ? value.toString() : "null") + "]");
                    }
                }
                c = c.getSuperclass();
            }
        }
    }

    public boolean accepts(Class<?> pojo) {
        return pojo.getAnnotation(Property.class) != null;
    }
}

