/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.kie.pmml.api.iinterfaces.SerializableFunction;
import org.kie.pmml.api.runtime.PMMLContext;

public abstract class KiePMMLRegressionTable
implements Serializable {
    private static final long serialVersionUID = -7899446939844650691L;
    protected Map<String, SerializableFunction<Double, Double>> numericFunctionMap = new HashMap<String, SerializableFunction<Double, Double>>();
    protected Map<String, SerializableFunction<String, Double>> categoricalFunctionMap = new HashMap<String, SerializableFunction<String, Double>>();
    protected Map<String, SerializableFunction<Map<String, Object>, Double>> predictorTermsFunctionMap = new HashMap<String, SerializableFunction<Map<String, Object>, Double>>();
    protected SerializableFunction<Double, Double> resultUpdater;
    protected double intercept;
    protected String targetField;
    protected Object targetCategory;

    public Object getTargetCategory() {
        return this.targetCategory;
    }

    public Object evaluateRegression(Map<String, Object> input, PMMLContext context) {
        String key;
        double result = this.intercept;
        HashMap<String, Double> resultMap = new HashMap<String, Double>();
        for (Map.Entry<String, SerializableFunction<Double, Double>> entry : this.numericFunctionMap.entrySet()) {
            key = entry.getKey();
            if (!input.containsKey(key)) continue;
            resultMap.put(key, (Double)entry.getValue().apply((Object)((Number)input.get(key)).doubleValue()));
        }
        for (Map.Entry<String, Object> entry : this.categoricalFunctionMap.entrySet()) {
            key = entry.getKey();
            if (!input.containsKey(key)) continue;
            resultMap.put(key, (Double)((SerializableFunction)entry.getValue()).apply((Object)input.get(key).toString()));
        }
        for (Map.Entry<String, Object> entry : this.predictorTermsFunctionMap.entrySet()) {
            resultMap.put(entry.getKey(), (Double)((SerializableFunction)entry.getValue()).apply(input));
        }
        for (Double d : resultMap.values()) {
            result += d.doubleValue();
        }
        if (this.resultUpdater != null) {
            result = (Double)this.resultUpdater.apply((Object)result);
        }
        return result;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public Map<String, SerializableFunction<Double, Double>> getNumericFunctionMap() {
        return this.numericFunctionMap;
    }

    public Map<String, SerializableFunction<String, Double>> getCategoricalFunctionMap() {
        return this.categoricalFunctionMap;
    }

    public Map<String, SerializableFunction<Map<String, Object>, Double>> getPredictorTermsFunctionMap() {
        return this.predictorTermsFunctionMap;
    }

    public double getIntercept() {
        return this.intercept;
    }

    protected double evaluateNumericWithExponent(double input, double coefficient, double exponent) {
        return Math.pow(input, exponent) * coefficient;
    }

    protected double evaluateNumericWithoutExponent(double input, double coefficient) {
        return input * coefficient;
    }

    protected double evaluateCategoricalPredictor(Object input, Map<String, Double> valuesMap) {
        return valuesMap.getOrDefault(input.toString(), 0.0);
    }

    protected double updateSOFTMAXResult(Double y) {
        return 1.0 / (1.0 + Math.exp(-y.doubleValue()));
    }

    protected double updateLOGITResult(Double y) {
        return 1.0 / (1.0 + Math.exp(-y.doubleValue()));
    }

    protected double updateEXPResult(Double y) {
        return Math.exp(y);
    }

    protected double updatePROBITResult(Double y) {
        return new NormalDistribution().cumulativeProbability(y.doubleValue());
    }

    protected double updateCLOGLOGResult(Double y) {
        return 1.0 - Math.exp(-Math.exp(y));
    }

    protected double updateCAUCHITResult(Double y) {
        return 0.5 + 0.3183098861837907 * Math.atan(y);
    }

    protected double updateNONEResult(Double y) {
        return y;
    }
}

