/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.elements;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsFactory;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.MetaDataType;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.elements.ElementDefinition;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;

public class MetaDataAttributesElement
extends ElementDefinition<String> {
    public static final String DELIMITER = "\u00d8";
    public static final String SEPARATOR = "\u00df";

    public MetaDataAttributesElement(String name) {
        super(name, "");
    }

    @Override
    public String getValue(BaseElement element) {
        return this.getStringValue(element).orElse((String)this.getDefaultValue());
    }

    @Override
    public void setValue(BaseElement element, String value) {
        this.setStringValue(element, value);
    }

    private void setStringValue(BaseElement element, String value) {
        Stream.of(value.split(DELIMITER)).map(this::extensionOf).forEach(arg_0 -> MetaDataAttributesElement.getExtensionElements(element).add(arg_0));
    }

    private Optional<String> getStringValue(BaseElement element) {
        List extValues = element.getExtensionValues();
        List extElementsList = extValues.stream().map(ExtensionAttributeValue::getValue).collect(Collectors.toList());
        List metadataExtensions = extElementsList.stream().map(extAttrVal -> (List)extAttrVal.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true)).flatMap(Collection::stream).collect(Collectors.toList());
        String metaDataAttributes = metadataExtensions.stream().filter(metaDataType -> metaDataType.getName() != null).filter(metaDataType -> MetaDataAttributesElement.isMetaDataAttribute(metaDataType.getName())).map(metaDataType -> metaDataType.getName() + SEPARATOR + (null != metaDataType.getMetaValue() && metaDataType.getMetaValue().length() > 0 ? metaDataType.getMetaValue() : "")).collect(Collectors.joining(DELIMITER));
        return Optional.ofNullable(metaDataAttributes);
    }

    protected FeatureMap.Entry extensionOf(String metaData) {
        return new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, (Object)this.metaDataTypeDataOf(metaData));
    }

    protected MetaDataType metaDataTypeDataOf(String metaData) {
        MetaDataType metaDataType = DroolsFactory.eINSTANCE.createMetaDataType();
        String[] properties = metaData.split(SEPARATOR);
        metaDataType.setName(properties[0]);
        metaDataType.setMetaValue(properties.length > 1 ? Scripts.asCData(properties[1]) : null);
        return metaDataType;
    }

    public static boolean isMetaDataAttribute(String metaDataTypeName) {
        if (metaDataTypeName.length() <= 0) {
            return false;
        }
        return !metaDataTypeName.equals(CustomElement.async.name()) && !metaDataTypeName.equals(CustomElement.autoStart.name()) && !metaDataTypeName.equals(CustomElement.autoConnectionSource.name()) && !metaDataTypeName.equals(CustomElement.autoConnectionTarget.name()) && !metaDataTypeName.equals(CustomElement.customTags.name()) && !metaDataTypeName.equals(CustomElement.description.name()) && !metaDataTypeName.equals(CustomElement.scope.name()) && !metaDataTypeName.equals(CustomElement.name.name()) && !metaDataTypeName.equals(CustomElement.caseIdPrefix.name()) && !metaDataTypeName.equals(CustomElement.caseRole.name()) && !metaDataTypeName.equals(CustomElement.slaDueDate.name()) && !metaDataTypeName.equals(CustomElement.isCase.name()) && !metaDataTypeName.equals(CustomElement.customActivationCondition.name()) && !metaDataTypeName.equals(CustomElement.abortParent.name());
    }
}

