/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.processes;

import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.SubProcess;
import org.kie.workbench.common.stunner.bpmn.backend.converters.NodeMatch;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.ConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.DefinitionsBuildingContext;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.processes.ProcessConverterDelegate;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.AdHocSubProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.MultipleInstanceSubProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.SubProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.BaseAdHocSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.BaseSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EventSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.MultipleInstanceSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.subProcess.execution.EmbeddedSubprocessExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.subProcess.execution.EventSubprocessExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseAdHocSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.BaseProcessData;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.BaseProcessVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class SubProcessConverter
extends ProcessConverterDelegate {
    private final DefinitionsBuildingContext context;
    private final PropertyWriterFactory propertyWriterFactory;

    public SubProcessConverter(DefinitionsBuildingContext context, PropertyWriterFactory propertyWriterFactory, ConverterFactory converterFactory) {
        super(converterFactory);
        this.context = context;
        this.propertyWriterFactory = propertyWriterFactory;
    }

    public Result<SubProcessPropertyWriter> convertSubProcess(Node<View<? extends BPMNViewDefinition>, ?> node) {
        Result<SubProcessPropertyWriter> processRootResult = NodeMatch.fromNode(BaseSubprocess.class, SubProcessPropertyWriter.class).when(EmbeddedSubprocess.class, this::convertEmbeddedSubprocessNode).when(EventSubprocess.class, this::convertEventSubprocessNode).when(BaseAdHocSubprocess.class, this::convertAdHocSubprocessNode).when(MultipleInstanceSubprocess.class, this::convertMultipleInstanceSubprocessNode).ignore(BPMNViewDefinition.class).apply(node);
        if (processRootResult.isIgnored()) {
            return processRootResult;
        }
        DefinitionsBuildingContext subContext = this.context.withRootNode((Node)node);
        SubProcessPropertyWriter processRoot = processRootResult.value();
        super.convertChildNodes(processRoot, subContext);
        super.convertEdges(processRoot, subContext);
        return processRootResult;
    }

    protected SubProcessPropertyWriter convertMultipleInstanceSubprocessNode(Node<View<MultipleInstanceSubprocess>, ?> n) {
        SubProcess process = Factories.bpmn2.createSubProcess();
        process.setId(n.getUUID());
        MultipleInstanceSubProcessPropertyWriter p = this.propertyWriterFactory.ofMultipleInstanceSubProcess(process);
        MultipleInstanceSubprocess definition = (MultipleInstanceSubprocess)((View)n.getContent()).getDefinition();
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        ProcessData processData = definition.getProcessData();
        p.setProcessVariables((BaseProcessVariables)processData.getProcessVariables());
        MultipleInstanceSubprocessTaskExecutionSet executionSet = definition.getExecutionSet();
        p.setIsSequential(executionSet.getMultipleInstanceExecutionMode().isSequential());
        p.setCollectionInput(executionSet.getMultipleInstanceCollectionInput().getValue());
        p.setInput(executionSet.getMultipleInstanceDataInput().getValue());
        p.setCollectionOutput(executionSet.getMultipleInstanceCollectionOutput().getValue());
        p.setOutput(executionSet.getMultipleInstanceDataOutput().getValue());
        p.setCompletionCondition(executionSet.getMultipleInstanceCompletionCondition().getValue());
        p.setOnEntryAction(executionSet.getOnEntryAction());
        p.setOnExitAction(executionSet.getOnExitAction());
        p.setAsync(executionSet.getIsAsync().getValue());
        p.setSlaDueDate(executionSet.getSlaDueDate());
        p.setSimulationSet(definition.getSimulationSet());
        p.setMetaData(definition.getAdvancedData().getMetaDataAttributes());
        p.setAbsoluteBounds(n);
        return p;
    }

    protected SubProcessPropertyWriter convertAdHocSubprocessNode(Node<View<BaseAdHocSubprocess>, ?> n) {
        AdHocSubProcess process = Factories.bpmn2.createAdHocSubProcess();
        process.setId(n.getUUID());
        AdHocSubProcessPropertyWriter p = this.propertyWriterFactory.of(process);
        BaseAdHocSubprocess definition = (BaseAdHocSubprocess)((View)n.getContent()).getDefinition();
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        BaseProcessData processData = definition.getProcessData();
        p.setProcessVariables(processData.getProcessVariables());
        BaseAdHocSubprocessTaskExecutionSet executionSet = definition.getExecutionSet();
        p.setAdHocActivationCondition(executionSet.getAdHocActivationCondition());
        p.setAdHocCompletionCondition(executionSet.getAdHocCompletionCondition());
        p.setAdHocOrdering(executionSet.getAdHocOrdering());
        p.setOnEntryAction(executionSet.getOnEntryAction());
        p.setOnExitAction(executionSet.getOnExitAction());
        p.setAsync(executionSet.getIsAsync().getValue());
        p.setSlaDueDate(executionSet.getSlaDueDate());
        p.setSimulationSet(definition.getSimulationSet());
        p.setMetaData(definition.getAdvancedData().getMetaDataAttributes());
        p.setAbsoluteBounds(n);
        p.setAdHocAutostart(executionSet.getAdHocAutostart().getValue());
        return p;
    }

    protected SubProcessPropertyWriter convertEventSubprocessNode(Node<View<EventSubprocess>, ?> n) {
        SubProcess process = Factories.bpmn2.createSubProcess();
        process.setId(n.getUUID());
        SubProcessPropertyWriter p = this.propertyWriterFactory.of(process);
        EventSubprocess definition = (EventSubprocess)((View)n.getContent()).getDefinition();
        process.setTriggeredByEvent(true);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        ProcessData processData = definition.getProcessData();
        p.setProcessVariables((BaseProcessVariables)processData.getProcessVariables());
        EventSubprocessExecutionSet executionSet = definition.getExecutionSet();
        p.setAsync(executionSet.getIsAsync().getValue());
        p.setSlaDueDate(executionSet.getSlaDueDate());
        p.setSimulationSet(definition.getSimulationSet());
        p.setMetaData(definition.getAdvancedData().getMetaDataAttributes());
        p.setAbsoluteBounds(n);
        return p;
    }

    protected SubProcessPropertyWriter convertEmbeddedSubprocessNode(Node<View<EmbeddedSubprocess>, ?> n) {
        SubProcess process = Factories.bpmn2.createSubProcess();
        process.setId(n.getUUID());
        SubProcessPropertyWriter p = this.propertyWriterFactory.of(process);
        EmbeddedSubprocess definition = (EmbeddedSubprocess)((View)n.getContent()).getDefinition();
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        EmbeddedSubprocessExecutionSet executionSet = definition.getExecutionSet();
        p.setOnEntryAction(executionSet.getOnEntryAction());
        p.setOnExitAction(executionSet.getOnExitAction());
        p.setAsync(executionSet.getIsAsync().getValue());
        p.setSlaDueDate(executionSet.getSlaDueDate());
        ProcessData processData = definition.getProcessData();
        p.setProcessVariables((BaseProcessVariables)processData.getProcessVariables());
        p.setSimulationSet(definition.getSimulationSet());
        p.setMetaData(definition.getAdvancedData().getMetaDataAttributes());
        p.setAbsoluteBounds(n);
        return p;
    }
}

