/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.workitem.deploy;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Dependencies;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class WorkItemDefinitionProjectInstaller {
    private static final String INSALL_MESSAGE = "Updated project dependencies from work item definitions";
    private final POMService pomService;
    private final MetadataService metadataService;
    private final KieModuleService moduleService;

    protected WorkItemDefinitionProjectInstaller() {
        this.pomService = null;
        this.metadataService = null;
        this.moduleService = null;
    }

    @Inject
    public WorkItemDefinitionProjectInstaller(POMService pomService, MetadataService metadataService, KieModuleService moduleService) {
        this.pomService = pomService;
        this.metadataService = metadataService;
        this.moduleService = moduleService;
    }

    public void install(Collection<WorkItemDefinition> items, Metadata metadata) {
        Module module = this.moduleService.resolveModule(metadata.getRoot());
        Path pomXMLPath = module.getPomXMLPath();
        POM projectPOM = (POM)this.pomService.load(pomXMLPath);
        if (projectPOM != null) {
            Dependencies projectDependencies = projectPOM.getDependencies();
            Set widDependencies = items.stream().flatMap(wid -> wid.getDependencies().stream()).filter(d -> !projectDependencies.contains(d)).collect(Collectors.toSet());
            projectDependencies.addAll(widDependencies);
            this.pomService.save(pomXMLPath, projectPOM, this.metadataService.getMetadata(pomXMLPath), INSALL_MESSAGE, false);
        }
    }
}

