/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.backend.server.util;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.screens.globals.model.Global;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.kie.soup.project.datamodel.commons.packages.PackageNameParser;
import org.kie.soup.project.datamodel.commons.packages.PackageNameWriter;
import org.kie.soup.project.datamodel.packages.HasPackageName;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.GlobalsParser;
import org.uberfire.commons.data.Pair;

public class GlobalsPersistence {
    private static final GlobalsPersistence INSTANCE = new GlobalsPersistence();

    protected GlobalsPersistence() {
    }

    public static GlobalsPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(GlobalsModel model) {
        StringBuilder sb = new StringBuilder();
        PackageNameWriter.write((StringBuilder)sb, (HasPackageName)model);
        for (Global global : model.getGlobals()) {
            sb.append("global ").append(global.getClassName()).append(" ").append(global.getAlias()).append(";\n");
        }
        return sb.toString();
    }

    public GlobalsModel unmarshal(String content) {
        List parsedGlobalsContent = GlobalsParser.parseGlobals((String)content);
        List<Global> globals = this.makeGlobals(parsedGlobalsContent);
        GlobalsModel model = new GlobalsModel();
        model.setGlobals(globals);
        String packageName = PackageNameParser.parsePackageName((String)content);
        model.setPackageName(packageName);
        return model;
    }

    private List<Global> makeGlobals(List<Pair<String, String>> parsedGlobalsContent) {
        ArrayList<Global> globals = new ArrayList<Global>();
        for (Pair<String, String> p : parsedGlobalsContent) {
            globals.add(new Global((String)p.getK1(), (String)p.getK2()));
        }
        return globals;
    }
}

