/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DockNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.RegisterNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SafeDeleteNodeCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Portable
public class AddDockedNodeCommand
extends AbstractGraphCompositeCommand {
    private final String parentUUID;
    private final Node candidate;
    private transient Node parent;

    public AddDockedNodeCommand(@MapsTo(value="parentUUID") String parentUUID, @MapsTo(value="candidate") Node candidate) {
        this.parentUUID = (String)PortablePreconditions.checkNotNull((String)"parentUUID", (Object)parentUUID);
        this.candidate = (Node)PortablePreconditions.checkNotNull((String)"candidate", (Object)candidate);
    }

    public AddDockedNodeCommand(Node parent, Node candidate) {
        this(parent.getUUID(), candidate);
        this.parent = parent;
    }

    protected AddDockedNodeCommand initialize(GraphCommandExecutionContext context) {
        super.initialize(context);
        this.addCommand(new RegisterNodeCommand(this.candidate)).addCommand(new DockNodeCommand(this.getParent(context), this.candidate));
        return this;
    }

    @Override
    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        return new SafeDeleteNodeCommand(this.getCandidate()).execute(context);
    }

    private Node<?, Edge> getParent(GraphCommandExecutionContext context) {
        if (null == this.parent) {
            this.parent = this.checkNodeNotNull(context, this.parentUUID);
        }
        return this.parent;
    }

    public Node getCandidate() {
        return this.candidate;
    }

    @Override
    protected boolean delegateRulesContextToChildren() {
        return true;
    }

    @Override
    public String toString() {
        return "AddDockedNodeCommand [parent=" + this.parentUUID + ", candidate=" + this.candidate.getUUID() + "]";
    }
}

