/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters;

import bpsim.NormalDistributionType;
import bpsim.PoissonDistributionType;
import bpsim.UniformDistributionType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.MetaDataType;
import org.junit.Assert;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.mockito.Mockito;

public class TestUtils {
    public static List<ExtensionAttributeValue> mockExtensionValues(EReference metadataFeatureName, String metadataElementName, String metadataElementValue) {
        ArrayList<MetaDataType> extensionElements = new ArrayList<MetaDataType>();
        MetaDataType metaDataType = (MetaDataType)Mockito.mock(MetaDataType.class);
        Mockito.when((Object)metaDataType.getName()).thenReturn((Object)metadataElementName);
        Mockito.when((Object)metaDataType.getMetaValue()).thenReturn((Object)metadataElementValue);
        extensionElements.add(metaDataType);
        FeatureMap featureMap = (FeatureMap)Mockito.mock(FeatureMap.class);
        Mockito.when((Object)featureMap.get((EStructuralFeature)metadataFeatureName, true)).thenReturn(extensionElements);
        ArrayList<ExtensionAttributeValue> extensionValues = new ArrayList<ExtensionAttributeValue>();
        ExtensionAttributeValue extensionAttributeValue = (ExtensionAttributeValue)Mockito.mock(ExtensionAttributeValue.class);
        Mockito.when((Object)extensionAttributeValue.getValue()).thenReturn((Object)featureMap);
        extensionValues.add(extensionAttributeValue);
        return extensionValues;
    }

    public static Bounds mockBounds(float x, float y) {
        Bounds bounds = (Bounds)Mockito.mock(Bounds.class);
        Mockito.when((Object)Float.valueOf(bounds.getX())).thenReturn((Object)Float.valueOf(x));
        Mockito.when((Object)Float.valueOf(bounds.getY())).thenReturn((Object)Float.valueOf(y));
        return bounds;
    }

    public static Bounds mockBounds(float x, float y, float width, float height) {
        Bounds bounds = TestUtils.mockBounds(x, y);
        Mockito.when((Object)Float.valueOf(bounds.getWidth())).thenReturn((Object)Float.valueOf(width));
        Mockito.when((Object)Float.valueOf(bounds.getHeight())).thenReturn((Object)Float.valueOf(height));
        return bounds;
    }

    public static void assertBounds(double x1, double y1, double x2, double y2, org.kie.workbench.common.stunner.core.graph.content.Bounds bounds) {
        Assert.assertEquals((double)x1, (double)bounds.getUpperLeft().getX(), (double)0.0);
        Assert.assertEquals((double)y1, (double)bounds.getUpperLeft().getY(), (double)0.0);
        Assert.assertEquals((double)x2, (double)bounds.getLowerRight().getX(), (double)0.0);
        Assert.assertEquals((double)y2, (double)bounds.getLowerRight().getY(), (double)0.0);
    }

    public static FormalExpression mockFormalExpression(String language, String body) {
        FormalExpression expression = TestUtils.mockFormalExpression(body);
        Mockito.when((Object)expression.getLanguage()).thenReturn((Object)language);
        return expression;
    }

    public static FormalExpression mockFormalExpression(String body) {
        FormalExpression expression = (FormalExpression)Mockito.mock(FormalExpression.class);
        Mockito.when((Object)expression.getBody()).thenReturn((Object)body);
        return expression;
    }

    public static FeatureMap.Entry mockFeatureMapEntry(String name, Object value) {
        FeatureMap.Entry entry = (FeatureMap.Entry)Mockito.mock(FeatureMap.Entry.class);
        EStructuralFeature feature = (EStructuralFeature)Mockito.mock(EStructuralFeature.class);
        Mockito.when((Object)feature.getName()).thenReturn((Object)name);
        Mockito.when((Object)entry.getEStructuralFeature()).thenReturn((Object)feature);
        Mockito.when((Object)entry.getValue()).thenReturn(value);
        return entry;
    }

    public static NormalDistributionType mockNormalDistributionType(double mean, double standardDeviation) {
        NormalDistributionType distributionType = (NormalDistributionType)Mockito.mock(NormalDistributionType.class);
        Mockito.when((Object)distributionType.getMean()).thenReturn((Object)mean);
        Mockito.when((Object)distributionType.getStandardDeviation()).thenReturn((Object)standardDeviation);
        return distributionType;
    }

    public static UniformDistributionType mockUniformDistributionType(double min, double max) {
        UniformDistributionType distributionType = (UniformDistributionType)Mockito.mock(UniformDistributionType.class);
        Mockito.when((Object)distributionType.getMin()).thenReturn((Object)min);
        Mockito.when((Object)distributionType.getMax()).thenReturn((Object)max);
        return distributionType;
    }

    public static PoissonDistributionType mockPoissonDistributionType(double mean) {
        PoissonDistributionType distributionType = (PoissonDistributionType)Mockito.mock(PoissonDistributionType.class);
        Mockito.when((Object)distributionType.getMean()).thenReturn((Object)mean);
        return distributionType;
    }

    public static <T extends BPMNViewDefinition> Node<View<T>, ?> newNode(T definition) {
        return TestUtils.newNode(UUID.uuid(), definition);
    }

    public static <T extends BPMNViewDefinition> Node<View<T>, ?> newNode(String UUID2, T definition) {
        NodeImpl node = new NodeImpl(UUID2);
        node.setContent((Object)new ViewImpl(definition, org.kie.workbench.common.stunner.core.graph.content.Bounds.create()));
        return node;
    }

    public static <T extends BPMNViewDefinition> Edge mockEdge(Node<View<T>, ?> sourceNode, Node<View<T>, ?> targetNode) {
        Edge edge = (Edge)Mockito.mock(Edge.class);
        Mockito.when((Object)edge.getContent()).thenReturn(Mockito.mock(Child.class));
        Mockito.when((Object)edge.getSourceNode()).thenReturn(sourceNode);
        Mockito.when((Object)edge.getTargetNode()).thenReturn(targetNode);
        return edge;
    }
}

