/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.jboss.drools.DroolsPackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TestDefinitionsWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TestUtils;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.LanePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.LanePropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LanePropertyReaderTest {
    private static final String NAME = "NAME";
    private static final String METADATA_ELEMENT_NAME = "elementname";
    private static final float X = 5.0f;
    private static final float Y = 6.0f;
    private static final float WIDTH = 7.0f;
    private static final float HEIGHT = 8.0f;
    private static final float PARENT_X = 1.0f;
    private static final float PARENT_Y = 2.0f;
    private static final float PARENT_WIDTH = 10.0f;
    private static final float PARENT_HEIGHT = 11.0f;
    private static double RESOLUTION_FACTOR = 1.234;
    @Mock
    private Lane lane;
    @Mock
    private BPMNDiagram diagram;
    @Mock
    private BPMNShape shape;
    private Bounds bounds;
    @Mock
    private BPMNShape parentLaneShape;
    private Bounds parentBounds;

    @Before
    public void setUp() {
        this.bounds = TestUtils.mockBounds(5.0f, 6.0f, 7.0f, 8.0f);
        Mockito.when((Object)this.shape.getBounds()).thenReturn((Object)this.bounds);
        this.parentBounds = TestUtils.mockBounds(1.0f, 2.0f, 10.0f, 11.0f);
        Mockito.when((Object)this.parentLaneShape.getBounds()).thenReturn((Object)this.parentBounds);
    }

    @Test
    public void JBPM_7523_shouldPreserveNameChars() {
        PropertyReaderFactory factory = new PropertyReaderFactory(new TestDefinitionsWriter().getDefinitionResolver());
        Lane lane = Factories.bpmn2.createLane();
        PropertyWriterFactory writerFactory = new PropertyWriterFactory();
        LanePropertyWriter w = writerFactory.of(lane);
        String aWeirdName = "   XXX  !!@@ <><> ";
        String aWeirdDoc = "   XXX  !!@@ <><> Docs ";
        w.setName(aWeirdName);
        w.setDocumentation(aWeirdDoc);
        LanePropertyReader r = factory.of(lane);
        Assertions.assertThat((String)r.getName()).isEqualTo(Scripts.asCData((String)aWeirdName));
        Assertions.assertThat((String)r.getDocumentation()).isEqualTo(Scripts.asCData((String)aWeirdDoc));
    }

    @Test
    public void testGetBounds() {
        LanePropertyReader propertyReader = new LanePropertyReader(this.lane, this.diagram, this.shape, RESOLUTION_FACTOR);
        org.kie.workbench.common.stunner.core.graph.content.Bounds result = propertyReader.getBounds();
        TestUtils.assertBounds(5.0 * RESOLUTION_FACTOR, 6.0 * RESOLUTION_FACTOR, 5.0 * RESOLUTION_FACTOR + 7.0 * RESOLUTION_FACTOR, 6.0 * RESOLUTION_FACTOR + 8.0 * RESOLUTION_FACTOR, result);
    }

    @Test
    public void testGetBoundsWithParentLaneShape() {
        LanePropertyReader propertyReader = new LanePropertyReader(this.lane, this.diagram, this.shape, this.parentLaneShape, RESOLUTION_FACTOR);
        org.kie.workbench.common.stunner.core.graph.content.Bounds result = propertyReader.getBounds();
        TestUtils.assertBounds(1.0 * RESOLUTION_FACTOR, 6.0 * RESOLUTION_FACTOR, 1.0 * RESOLUTION_FACTOR + 10.0 * RESOLUTION_FACTOR, 6.0 * RESOLUTION_FACTOR + 8.0 * RESOLUTION_FACTOR, result);
    }

    @Test
    public void testGetRectangleDimensionsSet() {
        LanePropertyReader propertyReader = new LanePropertyReader(this.lane, this.diagram, this.shape, RESOLUTION_FACTOR);
        RectangleDimensionsSet dimensionsSet = propertyReader.getRectangleDimensionsSet();
        this.assertRectangleDimensions(7.0 * RESOLUTION_FACTOR, 8.0 * RESOLUTION_FACTOR, dimensionsSet);
    }

    @Test
    public void testGetRectangleDimensionsSetWithParentShape() {
        LanePropertyReader propertyReader = new LanePropertyReader(this.lane, this.diagram, this.shape, this.parentLaneShape, RESOLUTION_FACTOR);
        RectangleDimensionsSet dimensionsSet = propertyReader.getRectangleDimensionsSet();
        this.assertRectangleDimensions(10.0 * RESOLUTION_FACTOR, 8.0 * RESOLUTION_FACTOR, dimensionsSet);
    }

    @Test
    public void testGetNameFromExtensionElement() {
        List<ExtensionAttributeValue> extensionValues = TestUtils.mockExtensionValues(DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, METADATA_ELEMENT_NAME, NAME);
        Mockito.when((Object)this.lane.getExtensionValues()).thenReturn(extensionValues);
        LanePropertyReader propertyReader = new LanePropertyReader(this.lane, this.diagram, this.shape, RESOLUTION_FACTOR);
        Assert.assertEquals((Object)NAME, (Object)propertyReader.getName());
    }

    @Test
    public void testGetNameFromNameValue() {
        LanePropertyReader propertyReader = new LanePropertyReader(this.lane, this.diagram, this.shape, RESOLUTION_FACTOR);
        Mockito.when((Object)this.lane.getExtensionValues()).thenReturn(null);
        Mockito.when((Object)this.lane.getName()).thenReturn((Object)NAME);
        Assert.assertEquals((Object)NAME, (Object)propertyReader.getName());
    }

    private void assertRectangleDimensions(double width, double height, RectangleDimensionsSet dimensionsSet) {
        Assert.assertEquals((double)width, (double)dimensionsSet.getWidth().getValue(), (double)0.0);
        Assert.assertEquals((double)height, (double)dimensionsSet.getHeight().getValue(), (double)0.0);
    }
}

