/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak.elytron;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.inject.Inject;
import org.uberfire.backend.server.security.elytron.ElytronIdentityHelper;
import org.uberfire.backend.server.security.elytron.ElytronIdentityHelperProducer;
import org.uberfire.ext.security.management.keycloak.elytron.KeyCloakElytronIdentityHelper;
import org.uberfire.security.WorkbenchUserManager;

@ApplicationScoped
@Specializes
public class KeyCloakElytronIdentityHelperProducer
extends ElytronIdentityHelperProducer {
    public static final String MANAGEMENT_SERVICES_SYSTEM_PROP = "org.uberfire.ext.security.management.api.userManagementServices";
    private boolean isKeyCloak;

    @Inject
    public KeyCloakElytronIdentityHelperProducer(WorkbenchUserManager workbenchUserManager) {
        super(workbenchUserManager);
    }

    @PostConstruct
    public void init() {
        String managementService = System.getProperties().getProperty(MANAGEMENT_SERVICES_SYSTEM_PROP, "");
        this.isKeyCloak = "KCCredentialsUserManagementService".equals(managementService) || "KCAdapterUserManagementService".equals(managementService);
    }

    @Produces
    public ElytronIdentityHelper getDefaultElytronIdentityHelper() {
        if (this.isKeyCloak) {
            return new KeyCloakElytronIdentityHelper();
        }
        return super.getDefaultElytronIdentityHelper();
    }
}

