/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.context.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.rule.context.CardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.ConnectionContext;
import org.kie.workbench.common.stunner.core.rule.context.ConnectorCardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.ContainmentContext;
import org.kie.workbench.common.stunner.core.rule.context.DockingContext;
import org.kie.workbench.common.stunner.core.rule.context.EdgeCardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.ElementCardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.GraphConnectionContext;
import org.kie.workbench.common.stunner.core.rule.context.GraphEvaluationState;
import org.kie.workbench.common.stunner.core.rule.context.NodeContainmentContext;
import org.kie.workbench.common.stunner.core.rule.context.NodeDockingContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.AbstractGraphEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.CardinalityContextImpl;
import org.kie.workbench.common.stunner.core.rule.context.impl.ConnectionContextImpl;
import org.kie.workbench.common.stunner.core.rule.context.impl.ConnectorCardinalityContextImpl;
import org.kie.workbench.common.stunner.core.rule.context.impl.ContainmentContextImpl;
import org.kie.workbench.common.stunner.core.rule.context.impl.DockingContextImpl;
import org.kie.workbench.common.stunner.core.rule.context.impl.EdgeCardinalityContextImpl;
import org.kie.workbench.common.stunner.core.rule.context.impl.ElementCardinalityContextImpl;
import org.kie.workbench.common.stunner.core.rule.context.impl.GraphConnectionContextImpl;
import org.kie.workbench.common.stunner.core.rule.context.impl.NodeContainmentContextImpl;
import org.kie.workbench.common.stunner.core.rule.context.impl.NodeDockingContextImpl;
import org.kie.workbench.common.stunner.core.rule.context.impl.StatefulGraphEvaluationState;
import org.kie.workbench.common.stunner.core.rule.context.impl.StatelessGraphEvaluationState;

public class RuleEvaluationContextBuilder {

    public static class StatelessGraphContextBuilder
    extends GraphContextBuilderImpl<StatelessGraphEvaluationState> {
        public StatelessGraphContextBuilder(Graph<?, ? extends Node> graph) {
            super(new StatelessGraphEvaluationState(graph));
        }
    }

    public static class StatefulGraphContextBuilder
    extends GraphContextBuilderImpl<StatefulGraphEvaluationState> {
        public StatefulGraphContextBuilder(Graph<?, ? extends Node> graph) {
            this(new StatefulGraphEvaluationState(graph));
        }

        public StatefulGraphContextBuilder(StatefulGraphEvaluationState state) {
            super(state);
        }
    }

    public static class GraphContextBuilderImpl<S extends GraphEvaluationState>
    extends GraphContextBuilder<S> {
        private final S state;

        public GraphContextBuilderImpl(S state) {
            this.state = state;
        }

        @Override
        public S getState() {
            return this.state;
        }
    }

    public static abstract class GraphContextBuilder<S extends GraphEvaluationState> {
        public abstract S getState();

        public NodeContainmentContext containment(Element<? extends Definition<?>> parent, Collection<Node<? extends Definition<?>, ? extends Edge>> candidates) {
            return this.populate(new NodeContainmentContextImpl(parent, candidates));
        }

        public NodeContainmentContext containment(Element<? extends Definition<?>> parent, Node<? extends Definition<?>, ? extends Edge> candidate) {
            return this.populate(new NodeContainmentContextImpl(parent, Collections.singleton(candidate)));
        }

        public NodeDockingContext docking(Element<? extends Definition<?>> parent, Node<? extends Definition<?>, ? extends Edge> candidate) {
            return this.populate(new NodeDockingContextImpl(parent, candidate));
        }

        public GraphConnectionContext connection(Edge<? extends View<?>, ? extends Node> connector, Optional<Node<? extends View<?>, ? extends Edge>> sourceNode, Optional<Node<? extends View<?>, ? extends Edge>> targetNode) {
            return this.populate(new GraphConnectionContextImpl(connector, sourceNode, targetNode));
        }

        public ElementCardinalityContext graphCardinality() {
            return this.populate(new ElementCardinalityContextImpl(Collections.emptyList(), Optional.empty()));
        }

        public ElementCardinalityContext cardinality(Collection<Element<? extends View<?>>> candidates, CardinalityContext.Operation operation) {
            return this.populate(new ElementCardinalityContextImpl(candidates, Optional.of(operation)));
        }

        public ConnectorCardinalityContext edgeCardinality(Element<? extends View<?>> candidate, Edge<? extends View<?>, Node> edge, EdgeCardinalityContext.Direction direction, Optional<CardinalityContext.Operation> operation) {
            return this.populate(new ConnectorCardinalityContextImpl(candidate, edge, direction, operation));
        }

        private <T extends AbstractGraphEvaluationContext> T populate(T context) {
            return context.setState(this::getState);
        }
    }

    public static class DomainContexts {
        public static ContainmentContext containment(Set<String> parentRoles, Set<String> candidateRoles) {
            return new ContainmentContextImpl(parentRoles, candidateRoles);
        }

        public static DockingContext docking(Set<String> parentRoles, Set<String> candidateRoles) {
            return new DockingContextImpl(parentRoles, candidateRoles);
        }

        public static ConnectionContext connection(String connectorRole, Optional<Set<String>> sourceRoles, Optional<Set<String>> targetRoles) {
            return new ConnectionContextImpl(connectorRole, sourceRoles, targetRoles);
        }

        public static CardinalityContext cardinality(Set<String> roles, int candidateCount, Optional<CardinalityContext.Operation> operation) {
            return new CardinalityContextImpl(roles, candidateCount, operation);
        }

        public static CardinalityContext cardinality(Set<String> roles, int currentCount, int candidateCount, Optional<CardinalityContext.Operation> operation) {
            return new CardinalityContextImpl(roles, currentCount, candidateCount, operation);
        }

        public static EdgeCardinalityContext edgeCardinality(Set<String> candidateRoles, String edgeRole, int candidateCount, EdgeCardinalityContext.Direction direction, Optional<CardinalityContext.Operation> operation) {
            return new EdgeCardinalityContextImpl(edgeRole, candidateRoles, candidateCount, operation, direction);
        }
    }
}

