/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jira;

import com.atlassian.jira.rest.client.NullProgressMonitor;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.domain.BasicIssue;
import com.atlassian.jira.rest.client.domain.SearchResult;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.jira.JiraAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="JiraJqlSearch.wid", name="JiraJqlSearch", displayName="JiraJqlSearch", defaultHandler="mvel: new org.jbpm.process.workitem.jira.JqlSearchWorkitemHandler(\"userName\", \"password\", \"repoURI\")", documentation="jira-workitem/index.html", category="jira-workitem", icon="JiraJqlSearch.png", parameters={@WidParameter(name="SearchQuery", required=true)}, results={@WidResult(name="SearchResults", runtimeType="java.util.Map")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="jira-workitem", version="7.64.0.Final")}, serviceInfo=@WidService(category="Jira", description="Create or update Jiras", keywords="jira,jql,search,query", action=@WidAction(title="Execute a Jql query"), authinfo=@WidAuth(required=true, params={"userName", "password", "repoURI"}, paramsdescription={"Jira user", "Jira password", "Repository URI"}, referencesite="https://www.atlassian.com/software/jira")))
public class JqlSearchWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String userName;
    private String password;
    private String repoURI;
    private JiraAuth auth;
    private static final Logger logger = LoggerFactory.getLogger(JqlSearchWorkitemHandler.class);
    private static final String RESULTS_VALUE = "SearchResults";

    public JqlSearchWorkitemHandler(String userName, String password, String repoURI) {
        this.userName = userName;
        this.password = password;
        this.repoURI = repoURI;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String jqlQuery = (String)workItem.getParameter("SearchQuery");
            if (this.auth == null) {
                this.auth = new JiraAuth(this.userName, this.password, this.repoURI);
            }
            HashMap results = new HashMap();
            HashMap<String, String> resultIssues = new HashMap<String, String>();
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            SearchResult searchResult = this.auth.getSearchRestClient().searchJql(jqlQuery, (ProgressMonitor)progressMonitor);
            Iterable foundIssues = searchResult.getIssues();
            for (BasicIssue issue : foundIssues) {
                resultIssues.put(issue.getKey(), issue.getSelf().toURL().toString());
            }
            results.put(RESULTS_VALUE, resultIssues);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            logger.error("Error executing workitem: " + e.getMessage());
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(JiraAuth auth) {
        this.auth = auth;
    }
}

