/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.List;
import java.util.stream.Collectors;
import org.drools.compiler.lang.api.CEDescrBuilder;
import org.drools.compiler.lang.api.ConditionalBranchDescrBuilder;
import org.drools.compiler.lang.api.PatternDescrBuilder;
import org.drools.compiler.lang.api.RuleDescrBuilder;
import org.drools.compiler.lang.descr.AndDescr;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.executor.KiePMMLStatusHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLDescrLhsFactory {
    static final String INPUT_FIELD = "$inputField";
    static final String INPUT_FIELD_CONDITIONAL = "$inputField.getValue() %s %s";
    static final String VALUE_PATTERN = "value %s %s";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLDescrLhsFactory.class.getName());
    final CEDescrBuilder<RuleDescrBuilder, AndDescr> builder;

    private KiePMMLDescrLhsFactory(CEDescrBuilder<RuleDescrBuilder, AndDescr> builder) {
        this.builder = builder;
    }

    public static KiePMMLDescrLhsFactory factory(CEDescrBuilder<RuleDescrBuilder, AndDescr> builder) {
        return new KiePMMLDescrLhsFactory(builder);
    }

    public void declareLhs(KiePMMLDroolsRule rule) {
        logger.trace("declareLhs {}", (Object)rule);
        PatternDescrBuilder patternDescrBuilder = this.builder.pattern(KiePMMLStatusHolder.class.getSimpleName()).id("$statusHolder", false);
        if (rule.getStatusConstraint() != null) {
            patternDescrBuilder.constraint(rule.getStatusConstraint());
        }
        if (rule.getAndConstraints() != null) {
            this.declareConstraintsAndOr(rule.getAndConstraints(), this.builder.and());
        }
        if (rule.getOrConstraints() != null) {
            this.declareConstraintsAndOr(rule.getOrConstraints(), this.builder.or());
        }
        if (rule.getXorConstraints() != null) {
            this.declareConstraintsXor(rule.getXorConstraints());
        }
        if (rule.getNotConstraints() != null) {
            this.declareNotConstraints(rule.getNotConstraints());
        }
        if (rule.getInConstraints() != null) {
            rule.getInConstraints().forEach(this::declareConstraintIn);
        }
        if (rule.getNotInConstraints() != null) {
            rule.getNotInConstraints().forEach(this::declareConstraintNotIn);
        }
        if (rule.getIfBreakField() != null) {
            this.declareIfBreak(rule.getIfBreakField(), rule.getIfBreakOperator(), rule.getIfBreakValue());
        }
    }

    protected void declareConstraintsAndOr(List<KiePMMLFieldOperatorValue> orConstraints, CEDescrBuilder<?, ?> andOrBuilder) {
        block4: for (KiePMMLFieldOperatorValue kiePMMLFieldOperatorValue : orConstraints) {
            if (kiePMMLFieldOperatorValue.getName() != null) {
                this.commonDeclarePatternWithConstraint(andOrBuilder, kiePMMLFieldOperatorValue.getName(), kiePMMLFieldOperatorValue.getConstraintsAsString());
            }
            if (kiePMMLFieldOperatorValue.getNestedKiePMMLFieldOperatorValues() == null) continue;
            switch (kiePMMLFieldOperatorValue.getOperator()) {
                case OR: {
                    this.declareConstraintsAndOr(kiePMMLFieldOperatorValue.getNestedKiePMMLFieldOperatorValues(), andOrBuilder.or());
                    continue block4;
                }
                case AND: {
                    this.declareConstraintsAndOr(kiePMMLFieldOperatorValue.getNestedKiePMMLFieldOperatorValues(), andOrBuilder.and());
                    continue block4;
                }
            }
            throw new KiePMMLException(String.format("Operator %s not managed inside declareConstraintsAndOr, yet", kiePMMLFieldOperatorValue.getOperator()));
        }
    }

    protected void declareConstraintsXor(List<KiePMMLFieldOperatorValue> xorConstraints) {
        if (xorConstraints.size() != 2) {
            throw new KiePMMLException("Expecting two fields for XOR constraints, retrieved " + xorConstraints.size());
        }
        String[] keys = new String[xorConstraints.size()];
        String[] values = new String[xorConstraints.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = xorConstraints.get(i).getName();
            values[i] = xorConstraints.get(i).getConstraintsAsString();
        }
        CEDescrBuilder andBuilder = this.builder.and();
        CEDescrBuilder notBuilder = andBuilder.not().and();
        this.commonDeclarePatternWithConstraint(notBuilder, keys[0], values[0]);
        this.commonDeclarePatternWithConstraint(notBuilder, keys[1], values[1]);
        CEDescrBuilder existsBuilder = andBuilder.exists().or();
        this.commonDeclarePatternWithConstraint(existsBuilder, keys[0], values[0]);
        this.commonDeclarePatternWithConstraint(existsBuilder.or(), keys[1], values[1]);
    }

    protected void declareNotConstraints(List<KiePMMLFieldOperatorValue> notConstraints) {
        CEDescrBuilder andBuilder = this.builder.and();
        CEDescrBuilder notBuilder = andBuilder.not().and();
        notConstraints.forEach(kiePMMLOperatorValue -> this.commonDeclarePatternWithConstraint(notBuilder, kiePMMLOperatorValue.getName(), kiePMMLOperatorValue.getConstraintsAsString()));
    }

    protected void commonDeclarePatternWithConstraint(CEDescrBuilder<?, ?> descrBuilder, String patternType, String constraintString) {
        descrBuilder.pattern(patternType).constraint(constraintString);
    }

    protected void declareConstraintIn(String patternType, List<Object> values) {
        String constraints = this.getInNotInConstraint(values);
        this.builder.pattern(patternType).constraint(constraints);
    }

    protected void declareConstraintNotIn(String patternType, List<Object> values) {
        String constraints = this.getInNotInConstraint(values);
        this.builder.not().pattern(patternType).constraint(constraints);
    }

    protected void declareIfBreak(String ifBreakField, String ifBreakOperator, Object ifBreakValue) {
        this.builder.pattern(ifBreakField).id(INPUT_FIELD, false);
        ConditionalBranchDescrBuilder condBranchBuilder = this.builder.conditionalBranch();
        condBranchBuilder.condition().constraint(String.format(INPUT_FIELD_CONDITIONAL, ifBreakOperator, ifBreakValue));
        condBranchBuilder.consequence().breaking(true).name("match");
    }

    protected String getInNotInConstraint(List<Object> values) {
        String expressionString = values.stream().map(Object::toString).collect(Collectors.joining(", ", "(", ")"));
        return String.format(VALUE_PATTERN, "in", expressionString);
    }
}

