/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;

public class JsonUtils {
    private JsonUtils() {
    }

    public static Optional<JsonNode> convertFromStringToJSONNode(String json) {
        if (json == null || json.isEmpty()) {
            return Optional.empty();
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(json);
            return Optional.of(jsonNode);
        }
        catch (JsonParseException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Generic error during json parsing: " + json, e);
        }
    }
}

