/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.workitem.upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.m2repo.backend.server.helpers.FormData;
import org.guvnor.m2repo.backend.server.helpers.HttpPostHelper;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepository;

@Typed(value={ServiceTaskHttpPostHelper.class})
public class ServiceTaskHttpPostHelper
extends HttpPostHelper {
    @Inject
    private GuvnorM2Repository repository;
    private Predicate<ArtifactRepository> filter = new Predicate<ArtifactRepository>(){

        @Override
        public boolean test(ArtifactRepository t) {
            return t.getName().equals("global-m2-repo") || t.getName().equals("workspace-m2-repo");
        }
    };

    public void handle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            response.setContentType("text/html");
            FormData formData = this.extractFormData(request);
            String result = this.upload(formData);
            if (result.equals("OK")) {
                response.getWriter().write(formData.getGav().toString());
            } else {
                response.getWriter().write(result);
            }
        }
        catch (Exception e) {
            response.getWriter().write("ERROR");
        }
    }

    protected void deploy(GAV gav, InputStream jarStream) {
        this.repository.deployArtifact(jarStream, gav, false, this.filter);
    }
}

