/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.commons.backend.rule.exception.RuleModelDRLPersistenceException;
import org.drools.workbench.models.datamodel.rule.PluggableIAction;
import org.optaplanner.workbench.models.datamodel.rule.ActionMediumConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.PersistenceExtensionUtils;

@ApplicationScoped
public class MediumConstraintMatchPersistenceExtension
implements RuleModelIActionPersistenceExtension {
    private static final Pattern CONSTRAINT_MATCH_PATTERN = Pattern.compile("scoreHolder\\.addMediumConstraintMatch\\(\\s*kcontext\\s*,.+\\);");

    public boolean accept(String iActionString) {
        return CONSTRAINT_MATCH_PATTERN.matcher(iActionString).matches();
    }

    public PluggableIAction unmarshal(String iActionString) throws RuleModelDRLPersistenceException {
        String[] parameters = PersistenceExtensionUtils.unwrapParenthesis(iActionString).split("\\s*,\\s*");
        if (parameters.length > 0 && "kcontext".equals(parameters[0]) && parameters.length == 2) {
            return new ActionMediumConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue(parameters[1]));
        }
        throw new RuleModelDRLPersistenceException("Could not unmarshal action string " + iActionString);
    }
}

