/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.editor.backend.service.impl.helpers;

import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class AbstractFormDefinitionHelper {
    private IOService ioService;
    private FormDefinitionSerializer serializer;
    private CommentedOptionFactory commentedOptionFactory;

    public AbstractFormDefinitionHelper(FormDefinitionSerializer serializer, IOService ioService, CommentedOptionFactory commentedOptionFactory) {
        this.serializer = serializer;
        this.ioService = ioService;
        this.commentedOptionFactory = commentedOptionFactory;
    }

    public boolean supports(org.uberfire.backend.vfs.Path path) {
        return path.getFileName().endsWith(".frm");
    }

    public void postProcess(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path destination) {
        Path destinationNioPath = Paths.convert((org.uberfire.backend.vfs.Path)destination);
        FormDefinition formDefinition = this.serializer.deserialize(this.ioService.readAllString(destinationNioPath));
        this.processFormDefinition(formDefinition, destination);
        this.ioService.write(destinationNioPath, this.serializer.serialize(formDefinition), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption("Updating form [" + destination.toURI() + "].")});
    }

    protected void processFormDefinition(FormDefinition formDefinition, org.uberfire.backend.vfs.Path formPath) {
        String newName = formPath.getFileName();
        newName = newName.substring(0, newName.lastIndexOf("."));
        formDefinition.setName(newName);
    }
}

