/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.builders.KiePMMLModelCodegenUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.regression.compiler.dto.RegressionCompilationDTO;
import org.kie.pmml.models.regression.compiler.factories.KiePMMLRegressionTableClassificationFactory;
import org.kie.pmml.models.regression.compiler.factories.KiePMMLRegressionTableRegressionFactory;
import org.kie.pmml.models.regression.model.KiePMMLRegressionModel;
import org.kie.pmml.models.regression.model.tuples.KiePMMLTableSourceCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLRegressionModelFactory {
    static final String KIE_PMML_REGRESSION_MODEL_TEMPLATE_JAVA = "KiePMMLRegressionModelTemplate.tmpl";
    static final String KIE_PMML_REGRESSION_MODEL_TEMPLATE = "KiePMMLRegressionModelTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLRegressionModelFactory.class.getName());

    private KiePMMLRegressionModelFactory() {
    }

    public static KiePMMLRegressionModel getKiePMMLRegressionModelClasses(RegressionCompilationDTO compilationDTO) throws IOException, IllegalAccessException, InstantiationException {
        logger.trace("getKiePMMLRegressionModelClasses {} {}", (Object)compilationDTO.getFields(), (Object)compilationDTO.getModel());
        Map<String, String> sourcesMap = KiePMMLRegressionModelFactory.getKiePMMLRegressionModelSourcesMap(compilationDTO);
        try {
            Class kiePMMLRegressionModelClass = compilationDTO.compileAndLoadClass(sourcesMap);
            return (KiePMMLRegressionModel)kiePMMLRegressionModelClass.newInstance();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLRegressionModelSourcesMap(RegressionCompilationDTO compilationDTO) throws IOException {
        logger.trace("getKiePMMLRegressionModelSourcesMap {} {} {}", new Object[]{compilationDTO.getFields(), compilationDTO.getModel(), compilationDTO.getPackageName()});
        String className = compilationDTO.getSimpleClassName();
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)compilationDTO.getPackageName(), (String)KIE_PMML_REGRESSION_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_REGRESSION_MODEL_TEMPLATE);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        Map<String, KiePMMLTableSourceCategory> tablesSourceMap = KiePMMLRegressionModelFactory.getRegressionTablesMap(compilationDTO);
        String nestedTable = tablesSourceMap.size() == 1 ? tablesSourceMap.keySet().iterator().next() : tablesSourceMap.keySet().stream().filter(tableName -> tableName.startsWith(compilationDTO.getPackageName() + ".KiePMMLRegressionTableClassification")).findFirst().orElseThrow(() -> new KiePMMLException("Failed to find expected KiePMMLRegressionTableClassification"));
        KiePMMLRegressionModelFactory.setConstructor((CompilationDTO<RegressionModel>)compilationDTO, modelTemplate, nestedTable);
        Map<String, String> toReturn = tablesSourceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((KiePMMLTableSourceCategory)entry.getValue()).getSource()));
        toReturn.put(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
        return toReturn;
    }

    static Map<String, KiePMMLTableSourceCategory> getRegressionTablesMap(RegressionCompilationDTO compilationDTO) {
        Map<String, KiePMMLTableSourceCategory> toReturn;
        if (compilationDTO.isRegression()) {
            List<RegressionTable> regressionTables = Collections.singletonList((RegressionTable)((RegressionModel)compilationDTO.getModel()).getRegressionTables().get(0));
            RegressionCompilationDTO regressionCompilationDTO = RegressionCompilationDTO.fromCompilationDTORegressionTablesAndNormalizationMethod((CompilationDTO<RegressionModel>)compilationDTO, regressionTables, ((RegressionModel)compilationDTO.getModel()).getNormalizationMethod());
            toReturn = KiePMMLRegressionTableRegressionFactory.getRegressionTables(regressionCompilationDTO);
        } else {
            List regressionTables = ((RegressionModel)compilationDTO.getModel()).getRegressionTables();
            RegressionCompilationDTO regressionCompilationDTO = RegressionCompilationDTO.fromCompilationDTORegressionTablesAndNormalizationMethod((CompilationDTO<RegressionModel>)compilationDTO, regressionTables, RegressionModel.NormalizationMethod.NONE);
            toReturn = KiePMMLRegressionTableClassificationFactory.getRegressionTables(regressionCompilationDTO);
        }
        return toReturn;
    }

    static void setConstructor(CompilationDTO<RegressionModel> compilationDTO, ClassOrInterfaceDeclaration modelTemplate, String nestedTable) {
        KiePMMLModelCodegenUtils.init(compilationDTO, (ClassOrInterfaceDeclaration)modelTemplate);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        BlockStmt body = constructorDeclaration.getBody();
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(nestedTable);
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"regressionTable", (Expression)objectCreationExpr);
    }
}

