/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.adapter.binding;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.DefinitionSetAdapterBindings;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;

public class BindableDefinitionSetAdapterImpl<T>
implements BindableDefinitionSetAdapter<T> {
    private final StunnerTranslationService translationService;
    private Class<?> type;
    private DefinitionSetAdapterBindings bindings;

    public static BindableDefinitionSetAdapterImpl<Object> create(StunnerTranslationService translationService) {
        return new BindableDefinitionSetAdapterImpl<Object>(translationService);
    }

    private BindableDefinitionSetAdapterImpl(StunnerTranslationService translationService) {
        this.translationService = translationService;
    }

    public void setBindings(Class<?> type, DefinitionSetAdapterBindings bindings) {
        this.type = type;
        this.bindings = bindings;
    }

    public String getId(T pojo) {
        String _id = BindableAdapterUtils.getDefinitionSetId(pojo.getClass());
        if (_id.contains("$")) {
            _id = _id.substring(0, _id.indexOf("$"));
        }
        return _id;
    }

    public String getDomain(T pojo) {
        return BindableAdapterUtils.getDefinitionSetDomain(pojo.getClass());
    }

    public String getDescription(T pojo) {
        String description = this.translationService.getDefinitionSetDescription(this.getId(pojo));
        return description != null && description.trim().length() > 0 ? description : this.getId(pojo);
    }

    public Set<String> getDefinitions(T pojo) {
        return this.bindings.getDefinitionIds();
    }

    public Class<? extends ElementFactory> getGraphFactoryType(T pojo) {
        return this.bindings.getGraphFactory();
    }

    public Annotation getQualifier(T pojo) {
        return this.bindings.getQualifier();
    }

    public Optional<String> getSvgNodeId(T pojo) {
        return this.translationService.getDefinitionSetSvgNodeId(this.getId(pojo));
    }

    public boolean accepts(Class<?> type) {
        return type.equals(this.type);
    }

    public int getPriority() {
        return 0;
    }
}

