/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.context.generation.dynamic.impl.marshalling;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jbpm.document.Document;
import org.jbpm.document.DocumentCollection;
import org.jbpm.document.Documents;
import org.jbpm.document.service.impl.DocumentCollectionImpl;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.AbstractFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContext;
import org.kie.workbench.common.forms.jbpm.model.authoring.documents.definition.DocumentCollectionFieldDefinition;
import org.kie.workbench.common.forms.jbpm.model.document.DocumentData;
import org.kie.workbench.common.forms.jbpm.model.document.DocumentStatus;
import org.kie.workbench.common.forms.jbpm.server.context.generation.dynamic.impl.marshalling.DocumentFieldValueMarshaller;
import org.kie.workbench.common.forms.jbpm.server.service.impl.documents.storage.UploadedDocumentStorage;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class DocumentCollectionFieldValueMarshaller
extends AbstractFieldValueMarshaller<DocumentCollection, Collection<DocumentData>, DocumentCollectionFieldDefinition> {
    public static final String SERVER_TEMPLATE_ID = "serverTemplateId";
    private static final Logger logger = LoggerFactory.getLogger(DocumentCollectionFieldValueMarshaller.class);
    private UploadedDocumentStorage documentStorage;

    @Inject
    public DocumentCollectionFieldValueMarshaller(UploadedDocumentStorage documentStorage) {
        this.documentStorage = documentStorage;
    }

    public void init(DocumentCollection originalValue, DocumentCollectionFieldDefinition fieldDefinition, FormDefinition currentForm, BackendFormRenderingContext currentContext) {
        super.init((Object)originalValue, (FieldDefinition)fieldDefinition, currentForm, currentContext);
        this.originalValue = Optional.ofNullable(originalValue).orElseGet(this::getInstance);
    }

    public Class<DocumentCollectionFieldDefinition> getSupportedField() {
        return DocumentCollectionFieldDefinition.class;
    }

    public Supplier<FieldValueMarshaller<DocumentCollection, Collection<DocumentData>, DocumentCollectionFieldDefinition>> newInstanceSupplier() {
        return () -> new DocumentCollectionFieldValueMarshaller(this.documentStorage);
    }

    public Collection<DocumentData> toFlatValue() {
        String templateId = (String)this.context.getAttributes().get(SERVER_TEMPLATE_ID);
        return ((DocumentCollection)this.originalValue).getDocuments().stream().map(document -> DocumentFieldValueMarshaller.fromDocument((Document)document, templateId)).collect(Collectors.toList());
    }

    public DocumentCollection toRawValue(Collection<DocumentData> flatValue) {
        if (flatValue == null) {
            return this.getInstance();
        }
        boolean newValues = flatValue.stream().anyMatch(documentData -> documentData.getStatus().equals((Object)DocumentStatus.NEW));
        if (!newValues && ((DocumentCollection)this.originalValue).getDocuments().size() == flatValue.size()) {
            return (DocumentCollection)this.originalValue;
        }
        this.originalValue = this.getInstance();
        flatValue.stream().map(documentData -> DocumentFieldValueMarshaller.toDocument(documentData, this.documentStorage)).filter(Objects::nonNull).forEach(document -> ((DocumentCollection)this.originalValue).addDocument(document));
        return (DocumentCollection)this.originalValue;
    }

    private DocumentCollection getInstance() {
        if ("org.jbpm.document.Documents".equals(((DocumentCollectionFieldDefinition)this.fieldDefinition).getStandaloneClassName())) {
            return new Documents();
        }
        return new DocumentCollectionImpl();
    }
}

