/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.util.Objects;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationParser;

public class AssociationDeclaration {
    private Direction direction;
    private Type type;
    private String source;
    private String target;

    public AssociationDeclaration(Direction direction, Type type, String source, String target) {
        this.direction = direction;
        this.type = type;
        this.source = source;
        this.target = target;
    }

    public static AssociationDeclaration fromString(String encoded) {
        return AssociationParser.parse(encoded);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.direction.prefix() + (this.type.equals((Object)Type.FromTo) ? this.target + this.type.op() + this.source : this.source + this.type.op() + this.target);
    }

    public boolean equals(Object other) {
        if (!(other instanceof AssociationDeclaration)) {
            return false;
        }
        AssociationDeclaration otherDeclaration = (AssociationDeclaration)other;
        return Objects.equals((Object)this.type, (Object)otherDeclaration.type) && Objects.equals(this.source, otherDeclaration.source) && Objects.equals(this.target, otherDeclaration.target) && Objects.equals((Object)this.direction, (Object)otherDeclaration.direction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.source, this.target, this.direction});
    }

    public static enum Type {
        FromTo("="),
        SourceTarget("->");

        private final String op;

        private Type(String op) {
            this.op = op;
        }

        public String op() {
            return this.op;
        }
    }

    public static enum Direction {
        Input("[din]"),
        Output("[dout]");

        private final String prefix;

        private Direction(String prefix) {
            this.prefix = prefix;
        }

        public String prefix() {
            return this.prefix;
        }
    }
}

