/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.sequenceflows;

import org.eclipse.bpmn2.SequenceFlow;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.ElementContainer;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.SequenceFlowPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.property.connectors.SequenceFlowExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceFlowConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceFlowConverter.class);
    private final PropertyWriterFactory propertyWriterFactory;

    public SequenceFlowConverter(PropertyWriterFactory propertyWriterFactory) {
        this.propertyWriterFactory = propertyWriterFactory;
    }

    public Result<BasePropertyWriter> toFlowElement(Edge<?, ?> edge, ElementContainer process) {
        ViewConnector connector = (ViewConnector)edge.getContent();
        org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow definition = (org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow)connector.getDefinition();
        SequenceFlow seq = Factories.bpmn2.createSequenceFlow();
        SequenceFlowPropertyWriter p = this.propertyWriterFactory.of(seq);
        seq.setId(edge.getUUID());
        BasePropertyWriter pSrc = process.getChildElement(edge.getSourceNode().getUUID());
        BasePropertyWriter pTgt = process.getChildElement(edge.getTargetNode().getUUID());
        if (pSrc == null || pTgt == null) {
            String msg = String.format("pSrc = %s, pTgt = %s", pSrc, pTgt);
            LOG.debug(msg);
            return Result.failure(msg, new MarshallingMessage[0]);
        }
        p.setSource(pSrc);
        p.setTarget(pTgt);
        p.setConnection((ViewConnector<? extends BPMNViewDefinition>)connector);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        SequenceFlowExecutionSet executionSet = definition.getExecutionSet();
        p.setPriority(executionSet.getPriority().getValue());
        p.setConditionExpression(executionSet.getConditionExpression().getValue());
        return Result.of(p, new MarshallingMessage[0]);
    }
}

