/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.stmt.BlockStmt;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.TextIndex;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLApplyFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLConstantFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLDiscretizeFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLFieldRefFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLMapValuesFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLNormContinuousFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLNormDiscreteFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLTextIndexFactory;

public class KiePMMLExpressionFactory {
    private static final String EXPRESSION_NOT_MANAGED = "Expression %s not managed";

    private KiePMMLExpressionFactory() {
    }

    public static BlockStmt getKiePMMLExpression(String variableName, Expression expression) {
        if (expression instanceof Apply) {
            return KiePMMLApplyFactory.getApplyVariableDeclaration(variableName, (Apply)expression);
        }
        if (expression instanceof Constant) {
            return KiePMMLConstantFactory.getConstantVariableDeclaration(variableName, (Constant)expression);
        }
        if (expression instanceof Discretize) {
            return KiePMMLDiscretizeFactory.getDiscretizeVariableDeclaration(variableName, (Discretize)expression);
        }
        if (expression instanceof FieldRef) {
            return KiePMMLFieldRefFactory.getFieldRefVariableDeclaration(variableName, (FieldRef)expression);
        }
        if (expression instanceof MapValues) {
            return KiePMMLMapValuesFactory.getMapValuesVariableDeclaration(variableName, (MapValues)expression);
        }
        if (expression instanceof NormContinuous) {
            return KiePMMLNormContinuousFactory.getNormContinuousVariableDeclaration(variableName, (NormContinuous)expression);
        }
        if (expression instanceof NormDiscrete) {
            return KiePMMLNormDiscreteFactory.getNormDiscreteVariableDeclaration(variableName, (NormDiscrete)expression);
        }
        if (expression instanceof TextIndex) {
            return KiePMMLTextIndexFactory.getTextIndexVariableDeclaration(variableName, (TextIndex)expression);
        }
        throw new IllegalArgumentException(String.format(EXPRESSION_NOT_MANAGED, expression.getClass()));
    }
}

