/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.adf.engine.shared.formGeneration.processing.fields;

import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.forms.adf.engine.shared.formGeneration.FormGenerationContext;
import org.kie.workbench.common.forms.adf.engine.shared.formGeneration.processing.FormElementProcessor;
import org.kie.workbench.common.forms.adf.engine.shared.formGeneration.processing.fields.FieldInitializer;
import org.kie.workbench.common.forms.adf.engine.shared.formGeneration.util.PropertyValueExtractor;
import org.kie.workbench.common.forms.adf.service.building.FieldStatusModifier;
import org.kie.workbench.common.forms.adf.service.definitions.elements.FieldElement;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FieldType;
import org.kie.workbench.common.forms.service.shared.FieldManager;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;

public abstract class AbstractFieldElementProcessor
implements FormElementProcessor<FieldElement> {
    protected FieldManager fieldManager;
    protected PropertyValueExtractor propertyValueExtractor;
    protected List<FieldInitializer> initializers = new ArrayList<FieldInitializer>();

    public AbstractFieldElementProcessor(FieldManager fieldManager, PropertyValueExtractor propertyValueExtractor) {
        this.fieldManager = fieldManager;
        this.propertyValueExtractor = propertyValueExtractor;
    }

    protected void registerInitializer(FieldInitializer fieldInitializer) {
        this.initializers.add(fieldInitializer);
    }

    @Override
    public Class<FieldElement> getSupportedElementType() {
        return FieldElement.class;
    }

    @Override
    public LayoutComponent processFormElement(FieldElement element, FormGenerationContext context) {
        FieldDefinition field;
        if (element.getPreferredType().equals(FieldType.class)) {
            field = this.fieldManager.getDefinitionByDataType(element.getTypeInfo());
        } else {
            field = this.fieldManager.getDefinitionByFieldType(element.getPreferredType(), element.getTypeInfo());
            if (field == null) {
                field = this.fieldManager.getDefinitionByDataType(element.getTypeInfo());
            }
        }
        if (field != null) {
            Object fullFieldName;
            FieldStatusModifier initializer;
            context.getFormDefinition().getFields().add(field);
            field.setId(element.getName());
            field.setName(element.getName());
            field.setBinding(element.getBinding());
            String label = context.getI18nHelper().getTranslation(element.getLabelKey());
            if (label == null || label.isEmpty()) {
                label = element.getName().substring(0, 1).toUpperCase() + element.getName().substring(1);
            }
            field.setLabel(label);
            String helpMessage = context.getI18nHelper().getTranslation(element.getHelpMessageKey());
            field.setHelpMessage(helpMessage);
            field.setRequired(Boolean.valueOf(element.isRequired()));
            field.setReadOnly(Boolean.valueOf(element.isReadOnly()));
            if (context.getModel() != null && (initializer = context.getStatusModifierForFieldName((String)(fullFieldName = context.getFormDefinitionSettings().getModelType() + "." + element.getName()))) != null) {
                initializer.modifyFieldStatus(field, this.propertyValueExtractor.readPropertyValue(context.getModel(), element.getName()));
            }
            for (FieldInitializer fieldInitializer : this.initializers) {
                if (!fieldInitializer.supports(field)) continue;
                fieldInitializer.initialize(field, element, context);
            }
            LayoutComponent component = new LayoutComponent("org.kie.workbench.common.forms.dynamic.client.rendering.FieldLayoutComponent");
            component.addProperty("form_id", context.getFormDefinition().getId());
            component.addProperty("field_id", field.getId());
            return component;
        }
        return null;
    }
}

