/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.forms.serializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;

@Dependent
public class KeyValueSerializer {
    protected static final String DELIMITER_ROWS = ",";
    protected static final String DELIMITER_KEY_VALUE = ":";
    private String delimiterRow;
    private String delimiterKeyValue;

    @Inject
    public KeyValueSerializer() {
        this.delimiterRow = DELIMITER_ROWS;
        this.delimiterKeyValue = DELIMITER_KEY_VALUE;
    }

    protected KeyValueSerializer(String delimiterRow, String delimiterKeyValue) {
        this.delimiterRow = delimiterRow;
        this.delimiterKeyValue = delimiterKeyValue;
    }

    public <T> List<T> deserialize(String value, BiFunction<String, String, T> builder) {
        return Optional.ofNullable(value).filter(s -> !s.isEmpty()).map(s -> Stream.of(s.split(this.delimiterRow)).map(entry -> entry.split(this.delimiterKeyValue)).map(entry -> builder.apply(entry[0], entry[1])).collect(Collectors.toList())).orElse(new ArrayList());
    }

    public <T> String serialize(Optional<List<T>> values, Function<T, Object> getKey, Function<T, Object> getValue) {
        return values.orElse(Collections.emptyList()).stream().map(row -> getKey.apply(row) + this.delimiterKeyValue + getValue.apply(row)).collect(Collectors.joining(this.delimiterRow));
    }
}

