/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.adapter.binding;

import java.util.HashMap;
import java.util.Map;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterFunctions;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindablePropertyAdapter;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;

public class BindablePropertyAdapterImpl<T, R>
implements BindablePropertyAdapter<T, R> {
    private final StunnerTranslationService translationService;
    private final BindableAdapterFunctions functions;
    private final Map<Class<?>, String> valueFields;

    public static BindablePropertyAdapterImpl<Object, Object> create(StunnerTranslationService translationService, BindableAdapterFunctions functions) {
        return BindablePropertyAdapterImpl.create(translationService, functions, new HashMap());
    }

    public static BindablePropertyAdapterImpl<Object, Object> create(StunnerTranslationService translationService, BindableAdapterFunctions functions, Map<Class<?>, String> valueFields) {
        return new BindablePropertyAdapterImpl<Object, Object>(translationService, functions, valueFields);
    }

    private BindablePropertyAdapterImpl(StunnerTranslationService translationService, BindableAdapterFunctions functions, Map<Class<?>, String> valueFields) {
        this.translationService = translationService;
        this.functions = functions;
        this.valueFields = valueFields;
    }

    public void addBinding(Class<?> type, String valueField) {
        this.valueFields.put(type, valueField);
    }

    public String getId(T pojo) {
        return BindableAdapterUtils.getPropertyId(pojo.getClass());
    }

    public String getCaption(T pojo) {
        return this.translationService.getPropertyCaption(this.getId(pojo));
    }

    public R getValue(T pojo) {
        return this.getFieldValue(pojo, this.valueFields.get(pojo.getClass()));
    }

    public void setValue(T pojo, R value) {
        this.setFieldValue(pojo, this.valueFields.get(pojo.getClass()), value);
    }

    public int getPriority() {
        return 0;
    }

    public boolean accepts(Class<?> type) {
        return this.valueFields.containsKey(type);
    }

    private void setFieldValue(T pojo, String field, R value) {
        this.functions.setValue(pojo, field, value);
    }

    private <R> R getFieldValue(T pojo, String field) {
        return (R)this.functions.getValue(pojo, field);
    }
}

