/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.util;

import java.util.Arrays;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String s) {
        return null == s || s.trim().length() == 0;
    }

    public static boolean nonEmpty(String s) {
        return !StringUtils.isEmpty(s);
    }

    public static boolean hasNonEmpty(String ... values) {
        return values != null && Arrays.stream(values).anyMatch(StringUtils::nonEmpty);
    }

    public static boolean isQuoted(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        return str.startsWith("\"") && str.endsWith("\"");
    }

    public static String createQuotedString(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        return "\"" + str + "\"";
    }

    public static String createQuotedStringIfNotNumeric(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return "\"" + str + "\"";
        }
        return str;
    }

    public static String replaceIllegalCharsAttribute(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String replaceIllegalCharsForDataObjects(String value) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case ' ': 
                case '\"': 
                case '#': 
                case ':': {
                    sb.append("-");
                    continue block5;
                }
                case '\n': {
                    continue block5;
                }
                case '\'': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '?': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    sb.append(c);
                    continue block5;
                }
                default: {
                    sb.append("-");
                }
            }
        }
        return sb.toString();
    }

    public static String revertIllegalCharsAttribute(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        return value.replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&").replace("&quot;", "\"");
    }

    public static String createUnquotedString(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (str.startsWith("\"")) {
            str = str.substring(1);
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

