/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.transform;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.transform.Transformer;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="TransformDefinitions.wid", name="Transform", displayName="Transform", defaultHandler="mvel: new org.jbpm.process.workitem.transform.TransformWorkItemHandler()", documentation="transform-workitem/index.html", category="transform-workitem", icon="Transform.png", parameters={@WidParameter(name="InputObject", required=true, runtimeType="java.lang.Object"), @WidParameter(name="OutputType", required=true)}, results={@WidResult(name="OutputObject", runtimeType="java.lang.Object")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="transform-workitem", version="7.66.0.Final")}, serviceInfo=@WidService(category="Transform", description="Transform Java input objects to output objects", keywords="transform,input,output", action=@WidAction(title="Transforma a Java input Object to an output Object"), authinfo=@WidAuth))
public class TransformWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(TransformWorkItemHandler.class);
    private static String INPUT_KEY = "InputObject";
    private static String OUTPUT_TYPE_KEY = "OutputType";
    private static String VARIABLE_OUTPUT_NAME = "OutputObject";
    private Map<Class<?>, Map<Class<?>, Method>> transforms = new HashMap();

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            Object in = workItem.getParameter(INPUT_KEY);
            String outputType = (String)workItem.getParameter(OUTPUT_TYPE_KEY);
            Object output = Class.forName(outputType).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method txMethod = this.findTransform(output.getClass(), in.getClass());
            if (txMethod != null) {
                Object out = txMethod.invoke(null, in);
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(VARIABLE_OUTPUT_NAME, out);
                manager.completeWorkItem(workItem.getId(), result);
            } else {
                logger.error("Failed to find a transform ");
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void registerTransformer(Class<?> transformer) {
        Method[] methods = transformer.getMethods();
        if (methods == null) {
            return;
        }
        for (Method meth : methods) {
            if (meth.getAnnotation(Transformer.class) == null) continue;
            Class<?> returnType = meth.getReturnType();
            Class<?> paramType = meth.getParameterTypes()[0];
            Map<Class<?>, Method> index = this.transforms.get(returnType);
            if (index == null) {
                index = new HashMap();
                this.transforms.put(returnType, index);
            }
            index.put(paramType, meth);
        }
    }

    private Method findTransform(Class<?> returnClass, Class<?> paramClass) {
        Map<Class<?>, Method> indexedTxForm = this.transforms.get(returnClass);
        if (indexedTxForm == null) {
            return null;
        }
        return indexedTxForm.get(paramClass);
    }

    public void abortWorkItem(WorkItem arg0, WorkItemManager arg1) {
    }
}

