/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.service.impl.documents;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.forms.jbpm.server.service.impl.documents.DocumentUploadSession;
import org.kie.workbench.common.forms.jbpm.server.service.impl.documents.storage.UploadedDocumentStorage;
import org.kie.workbench.common.forms.jbpm.service.shared.documents.DocumentUploadChunk;
import org.kie.workbench.common.forms.jbpm.service.shared.documents.DocumentUploadResponse;
import org.kie.workbench.common.forms.jbpm.service.shared.documents.UploadedDocumentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@SessionScoped
public class UploadedDocumentServiceImpl
implements UploadedDocumentService,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(UploadedDocumentServiceImpl.class);
    protected Map<String, DocumentUploadSession> uploadSessions = new HashMap<String, DocumentUploadSession>();
    private UploadedDocumentStorage storage;

    @Inject
    public UploadedDocumentServiceImpl(UploadedDocumentStorage storage) {
        this.storage = storage;
    }

    public DocumentUploadResponse uploadContent(DocumentUploadChunk chunk) {
        try {
            DocumentUploadSession session = this.getSession(chunk);
            if (session.isComplete()) {
                return this.merge(session);
            }
            return new DocumentUploadResponse(DocumentUploadResponse.DocumentUploadState.UPLOADING, true);
        }
        catch (Exception ex) {
            logger.warn("Cannot upload chunk {}: {}", (Object)chunk.getDocumentName(), (Object)ex);
            return new DocumentUploadResponse(DocumentUploadResponse.DocumentUploadState.FINISH, false);
        }
    }

    private DocumentUploadResponse merge(DocumentUploadSession session) {
        try {
            session.setState(DocumentUploadSession.State.MERGING);
            this.storage.merge(session);
            this.uploadSessions.remove(session.getDocumentId());
            return new DocumentUploadResponse(DocumentUploadResponse.DocumentUploadState.FINISH, true);
        }
        catch (Exception ex) {
            logger.warn("Error uploading content: ", (Throwable)ex);
            return new DocumentUploadResponse(DocumentUploadResponse.DocumentUploadState.FINISH, false);
        }
    }

    private DocumentUploadSession getSession(DocumentUploadChunk chunk) throws Exception {
        DocumentUploadSession session = this.uploadSessions.get(chunk.getDocumentId());
        if (session == null) {
            session = new DocumentUploadSession(chunk.getDocumentId(), chunk.getDocumentName(), chunk.getMaxChunks());
            this.uploadSessions.put(session.getDocumentId(), session);
        }
        session.add(chunk);
        this.storage.uploadContentChunk(chunk);
        return session;
    }

    public void removeContent(String id) {
        DocumentUploadSession session = this.uploadSessions.remove(id);
        if (session != null) {
            session.setState(DocumentUploadSession.State.ABORTED);
            this.storage.removeContent(id);
        } else {
            this.storage.removeContent(id);
        }
    }

    @PreDestroy
    public void clear() {
        this.uploadSessions.clear();
        this.storage.clear();
    }
}

