/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.elements;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Process;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.GlobalType;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.elements.GlobalVariablesElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;

public class GlobalVariablesElementTest {
    private final String GLOBAL_VARIABLES = "GV1:Boolean,GV2:Boolean,GV3:Integer";
    private final String NAME = "DefaultImports";
    private final String GLOBAL_VARIABLE = "GV1:Boolean";

    @Test
    public void testGetValue() {
        Process baseElement = Factories.bpmn2.createProcess();
        CustomElement.globalVariables.of((BaseElement)baseElement).set((Object)"GV1:Boolean,GV2:Boolean,GV3:Integer");
        Assert.assertEquals((Object)"GV1:Boolean,GV2:Boolean,GV3:Integer", (Object)CustomElement.globalVariables.of((BaseElement)baseElement).get());
    }

    @Test
    public void testSetValue() {
        Process baseElement = Factories.bpmn2.createProcess();
        CustomElement.globalVariables.of((BaseElement)baseElement).set((Object)"GV1:Boolean,GV2:Boolean,GV3:Integer");
        Assert.assertEquals((Object)"GV1:Boolean,GV2:Boolean,GV3:Integer", (Object)CustomElement.globalVariables.of((BaseElement)baseElement).get());
    }

    @Test
    public void testExtensionOf() {
        GlobalVariablesElement globalVariablesElement = new GlobalVariablesElement("DefaultImports");
        GlobalType globalType = GlobalVariablesElement.globalTypeDataOf((String)"GV1:Boolean");
        FeatureMap.Entry entry = GlobalVariablesElement.extensionOf((String)"GV1:Boolean");
        Assert.assertNotNull((Object)entry);
        Assert.assertTrue((boolean)(entry instanceof EStructuralFeatureImpl.SimpleFeatureMapEntry));
        Assert.assertEquals((Object)DroolsPackage.Literals.DOCUMENT_ROOT__GLOBAL, (Object)entry.getEStructuralFeature());
        Assert.assertNotNull((Object)entry.getValue());
        Assert.assertEquals((Object)globalType.getIdentifier(), (Object)((GlobalType)entry.getValue()).getIdentifier());
        Assert.assertEquals((Object)globalType.getType(), (Object)((GlobalType)entry.getValue()).getType());
    }

    @Test
    public void testGlobalTypeDataOf() {
        GlobalVariablesElement globalVariablesElement = new GlobalVariablesElement("DefaultImports");
        GlobalType globalType = GlobalVariablesElement.globalTypeDataOf((String)"GV1:Boolean");
        Assert.assertTrue((boolean)"GV1:Boolean".startsWith(globalType.getIdentifier()));
        Assert.assertTrue((boolean)"GV1:Boolean".endsWith(globalType.getType()));
    }
}

