/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.WrappedMessageTypeIdMapper;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ByteArrayOutputStreamEx;
import org.infinispan.protostream.impl.EnumMarshallerDelegate;
import org.infinispan.protostream.impl.RawProtoStreamReaderImpl;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.infinispan.protostream.impl.WireFormat;

public final class WrappedMessage {
    public static final String PROTOBUF_TYPE_NAME = "org.infinispan.protostream.WrappedMessage";
    public static final int PROTOBUF_TYPE_ID = 0;
    public static final String PROTO_FILE = "org/infinispan/protostream/message-wrapping.proto";
    public static final int WRAPPED_DOUBLE = 1;
    public static final int WRAPPED_FLOAT = 2;
    public static final int WRAPPED_INT64 = 3;
    public static final int WRAPPED_UINT64 = 4;
    public static final int WRAPPED_INT32 = 5;
    public static final int WRAPPED_FIXED64 = 6;
    public static final int WRAPPED_FIXED32 = 7;
    public static final int WRAPPED_BOOL = 8;
    public static final int WRAPPED_STRING = 9;
    public static final int WRAPPED_CHAR = 20;
    public static final int WRAPPED_SHORT = 21;
    public static final int WRAPPED_BYTE = 22;
    public static final int WRAPPED_DATE_MILLIS = 23;
    public static final int WRAPPED_INSTANT_SECONDS = 24;
    public static final int WRAPPED_INSTANT_NANOS = 25;
    public static final int WRAPPED_BYTES = 10;
    public static final int WRAPPED_UINT32 = 11;
    public static final int WRAPPED_SFIXED32 = 12;
    public static final int WRAPPED_SFIXED64 = 13;
    public static final int WRAPPED_SINT32 = 14;
    public static final int WRAPPED_SINT64 = 15;
    public static final int WRAPPED_DESCRIPTOR_FULL_NAME = 16;
    public static final int WRAPPED_MESSAGE = 17;
    public static final int WRAPPED_ENUM = 18;
    public static final int WRAPPED_DESCRIPTOR_TYPE_ID = 19;
    @Deprecated
    public static final int WRAPPED_DESCRIPTOR_ID = 19;
    private final Object value;

    public WrappedMessage(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    static void writeMessage(ImmutableSerializationContext ctx, RawProtoStreamWriter out, Object t) throws IOException {
        if (t == null) {
            return;
        }
        if (t instanceof String) {
            out.writeString(9, (String)t);
        } else if (t instanceof Character) {
            out.writeInt32(20, ((Character)t).charValue());
        } else if (t instanceof Byte) {
            out.writeInt32(22, ((Byte)t).byteValue());
        } else if (t instanceof Short) {
            out.writeInt32(21, ((Short)t).shortValue());
        } else if (t instanceof Date) {
            out.writeInt64(23, ((Date)t).getTime());
        } else if (t instanceof Instant) {
            Instant instant = (Instant)t;
            out.writeInt64(24, instant.getEpochSecond());
            out.writeInt32(25, instant.getNano());
        } else if (t instanceof Long) {
            out.writeInt64(3, (Long)t);
        } else if (t instanceof Integer) {
            out.writeInt32(5, (Integer)t);
        } else if (t instanceof Double) {
            out.writeDouble(1, (Double)t);
        } else if (t instanceof Float) {
            out.writeFloat(2, ((Float)t).floatValue());
        } else if (t instanceof Boolean) {
            out.writeBool(8, (Boolean)t);
        } else if (t instanceof byte[]) {
            out.writeBytes(10, (byte[])t);
        } else {
            BaseMarshallerDelegate<?> marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(t.getClass());
            BaseMarshaller<?> marshaller = marshallerDelegate.getMarshaller();
            String typeName = marshaller.getTypeName();
            int typeId = WrappedMessage.mapTypeIdOut(typeName, ctx);
            if (typeId < 0) {
                out.writeString(16, typeName);
            } else {
                out.writeUInt32(19, typeId);
            }
            if (t.getClass().isEnum()) {
                ((EnumMarshallerDelegate)marshallerDelegate).writeEnum(18, (Enum)t, out);
            } else {
                ByteArrayOutputStreamEx buffer = new ByteArrayOutputStreamEx();
                RawProtoStreamWriter nestedOut = RawProtoStreamWriterImpl.newInstance(buffer);
                marshallerDelegate.marshall(null, t, null, nestedOut);
                nestedOut.flush();
                out.writeBytes(17, buffer.getByteBuffer());
            }
        }
        out.flush();
    }

    static <T> T readMessage(ImmutableSerializationContext ctx, RawProtoStreamReader in) throws IOException {
        int tag;
        String descriptorFullName = null;
        Integer typeId = null;
        int enumValue = -1;
        byte[] messageBytes = null;
        Object value = null;
        int fieldCount = 0;
        int expectedFieldCount = 1;
        block27: while ((tag = in.readTag()) != 0) {
            ++fieldCount;
            switch (tag) {
                case 130: {
                    expectedFieldCount = 2;
                    descriptorFullName = in.readString();
                    continue block27;
                }
                case 152: {
                    expectedFieldCount = 2;
                    typeId = WrappedMessage.mapTypeIdIn(in.readInt32(), ctx);
                    continue block27;
                }
                case 144: {
                    enumValue = in.readEnum();
                    continue block27;
                }
                case 138: {
                    messageBytes = in.readByteArray();
                    continue block27;
                }
                case 74: {
                    value = in.readString();
                    continue block27;
                }
                case 160: {
                    value = Character.valueOf((char)in.readInt32());
                    continue block27;
                }
                case 168: {
                    value = (short)in.readInt32();
                    continue block27;
                }
                case 176: {
                    value = (byte)in.readInt32();
                    continue block27;
                }
                case 184: {
                    value = new Date(in.readInt64());
                    continue block27;
                }
                case 192: {
                    expectedFieldCount = 2;
                    long seconds = in.readInt64();
                    value = value == null ? Instant.ofEpochSecond(seconds, 0L) : Instant.ofEpochSecond(seconds, ((Instant)value).getNano());
                    continue block27;
                }
                case 200: {
                    expectedFieldCount = 2;
                    int nanos = in.readInt32();
                    value = value == null ? Instant.ofEpochSecond(0L, nanos) : Instant.ofEpochSecond(((Instant)value).getEpochSecond(), nanos);
                    continue block27;
                }
                case 82: {
                    value = in.readByteArray();
                    continue block27;
                }
                case 64: {
                    value = in.readBool();
                    continue block27;
                }
                case 9: {
                    value = in.readDouble();
                    continue block27;
                }
                case 21: {
                    value = Float.valueOf(in.readFloat());
                    continue block27;
                }
                case 61: {
                    value = in.readFixed32();
                    continue block27;
                }
                case 101: {
                    value = in.readSFixed32();
                    continue block27;
                }
                case 49: {
                    value = in.readFixed64();
                    continue block27;
                }
                case 105: {
                    value = in.readSFixed64();
                    continue block27;
                }
                case 24: {
                    value = in.readInt64();
                    continue block27;
                }
                case 32: {
                    value = in.readUInt64();
                    continue block27;
                }
                case 120: {
                    value = in.readSInt64();
                    continue block27;
                }
                case 40: {
                    value = in.readInt32();
                    continue block27;
                }
                case 88: {
                    value = in.readUInt32();
                    continue block27;
                }
                case 112: {
                    value = in.readSInt32();
                    continue block27;
                }
            }
            throw new IllegalStateException("Unexpected tag : " + tag + " (Field number : " + WireFormat.getTagFieldNumber(tag) + ", Wire type : " + WireFormat.getTagWireType(tag) + ")");
        }
        if (value == null && descriptorFullName == null && typeId == null && messageBytes == null) {
            return null;
        }
        if (value != null) {
            if (fieldCount != expectedFieldCount) {
                throw new IOException("Invalid message encoding.");
            }
            return (T)value;
        }
        if (descriptorFullName == null && typeId == null || descriptorFullName != null && typeId != null || fieldCount != 2) {
            throw new IOException("Invalid message encoding.");
        }
        if (typeId != null) {
            descriptorFullName = ctx.getDescriptorByTypeId(typeId).getFullName();
        }
        BaseMarshallerDelegate marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(descriptorFullName);
        if (messageBytes != null) {
            RawProtoStreamReader nestedInput = RawProtoStreamReaderImpl.newInstance(messageBytes);
            return marshallerDelegate.unmarshall(null, null, nestedInput);
        }
        EnumMarshaller marshaller = (EnumMarshaller)marshallerDelegate.getMarshaller();
        Object e = marshaller.decode(enumValue);
        if (e == null) {
            throw new IOException("Unknown enum value " + enumValue + " for Protobuf enum type " + descriptorFullName);
        }
        return (T)e;
    }

    private static int mapTypeIdIn(int typeId, ImmutableSerializationContext ctx) {
        WrappedMessageTypeIdMapper mapper = ctx.getConfiguration().wrappingConfig().wrappedMessageTypeIdMapper();
        return mapper == null ? typeId : mapper.mapTypeIdIn(typeId, ctx);
    }

    private static int mapTypeIdOut(String typeName, ImmutableSerializationContext ctx) {
        Integer typeId = ctx.getDescriptorByName(typeName).getTypeId();
        if (typeId == null) {
            return -1;
        }
        WrappedMessageTypeIdMapper mapper = ctx.getConfiguration().wrappingConfig().wrappedMessageTypeIdMapper();
        return mapper == null ? typeId.intValue() : mapper.mapTypeIdOut(typeId, ctx);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrappedMessage other = (WrappedMessage)o;
        return this.value != null ? this.value.equals(other.value) : other.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return "WrappedMessage{value=" + this.value + '}';
    }

    static final class Marshaller
    implements RawProtobufMarshaller<WrappedMessage> {
        Marshaller() {
        }

        @Override
        public Class<WrappedMessage> getJavaClass() {
            return WrappedMessage.class;
        }

        @Override
        public String getTypeName() {
            return WrappedMessage.PROTOBUF_TYPE_NAME;
        }

        @Override
        public WrappedMessage readFrom(ImmutableSerializationContext ctx, RawProtoStreamReader in) throws IOException {
            return new WrappedMessage(WrappedMessage.readMessage(ctx, in));
        }

        @Override
        public void writeTo(ImmutableSerializationContext ctx, RawProtoStreamWriter out, WrappedMessage wrappedMessage) throws IOException {
            WrappedMessage.writeMessage(ctx, out, wrappedMessage.value);
        }
    }
}

