/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.workitem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.AFReleaseIdImpl;
import org.guvnor.common.services.project.model.Dependencies;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepository;
import org.jbpm.process.workitem.repository.RepositoryEventListener;
import org.jbpm.process.workitem.repository.RepositoryStorage;
import org.jbpm.process.workitem.repository.service.RepoData;
import org.jbpm.workbench.wi.backend.server.workitem.ServiceTaskUtils;
import org.jbpm.workbench.wi.workitems.model.ServiceTaskResourceEvent;
import org.jbpm.workbench.wi.workitems.model.ServiceTasksConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceChangeType;

@ApplicationScoped
public class WorkbenchRepositoryEventListener
implements RepositoryEventListener {
    private static final Logger logger = LoggerFactory.getLogger(WorkbenchRepositoryEventListener.class);
    private static final String REPOSITORY_CONTENT_LOCATION = "/service-tasks/";
    private String repositoryVersion;
    private Predicate<ArtifactRepository> filter = new Predicate<ArtifactRepository>(){

        @Override
        public boolean test(ArtifactRepository t) {
            return t.getName().equals("global-m2-repo") || t.getName().equals("workspace-m2-repo");
        }
    };
    @Inject
    @Named(value="serviceTasksStorageVFS")
    private RepositoryStorage<ServiceTasksConfiguration> repositoryStorage;
    @Inject
    private GuvnorM2Repository m2Repository;
    @Inject
    private ServletContext servletContext;
    @Inject
    private POMService pomService;
    @Inject
    private ModuleService<?> moduleService;
    @Inject
    private MetadataService metadataService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Event<ServiceTaskResourceEvent> serviceTaskResourceEvent;

    @PostConstruct
    public void init() {
        Properties properties = new Properties();
        try (InputStream stream = this.getClass().getResourceAsStream("/service-tasks.properties");){
            properties.load(stream);
            this.repositoryVersion = properties.getProperty("version");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onServiceTaskAdded(RepoData service) {
    }

    public void onServiceTaskEnabled(RepoData service) {
        AFReleaseId releaseId;
        GAV gav;
        String pomProperties;
        String resourceLocation;
        InputStream stream;
        logger.info("Service task {} has been enabled", (Object)service.getName());
        if (((ServiceTasksConfiguration)this.repositoryStorage.loadConfiguration()).getMavenInstall().booleanValue() && (stream = this.servletContext.getResourceAsStream(resourceLocation = REPOSITORY_CONTENT_LOCATION + service.getModule() + "/" + service.getModule() + "-" + this.repositoryVersion + ".jar")) != null && (pomProperties = GuvnorM2Repository.loadPomPropertiesFromJar((InputStream)stream)) != null && !this.m2Repository.containsArtifact(gav = new GAV((releaseId = AFReleaseIdImpl.fromPropertiesString((String)pomProperties)).getGroupId(), releaseId.getArtifactId(), releaseId.getVersion()), this.filter) && !ServiceTaskUtils.DEFAULT_HANDLERS.contains(service.getModule())) {
            stream = this.servletContext.getResourceAsStream(resourceLocation);
            this.m2Repository.deployArtifact(stream, gav, false, this.filter);
            logger.info("Service task {} has been installed in maven", (Object)service.getName());
        }
    }

    public void onServiceTaskDisabled(RepoData service) {
        logger.info("Service task {} has been disabled", (Object)service.getName());
    }

    public void onServiceTaskInstalled(RepoData service, String target, List<String> parameters, String branchName) {
        try {
            boolean installPomDepds = ((ServiceTasksConfiguration)this.repositoryStorage.loadConfiguration()).getInstallPomDeps();
            org.uberfire.backend.vfs.Path path = this.getTargetPath("pom.xml", branchName, target);
            Module module = this.moduleService.resolveModule(path);
            POM projectPOM = (POM)this.pomService.load(module.getPomXMLPath());
            if (installPomDepds && projectPOM != null && !ServiceTaskUtils.DEFAULT_HANDLERS.contains(service.getModule())) {
                boolean useVersionRange = ((ServiceTasksConfiguration)this.repositoryStorage.loadConfiguration()).getVersionRange();
                Dependencies projectDepends = projectPOM.getDependencies();
                Dependencies validDependsFromWorkitem = this.getValidDependenciesForWorkitem(projectDepends, service, useVersionRange);
                if (validDependsFromWorkitem != null && validDependsFromWorkitem.size() > 0) {
                    for (Dependency workitemDependency : validDependsFromWorkitem) {
                        projectPOM.getDependencies().add(workitemDependency);
                    }
                    this.pomService.save(module.getPomXMLPath(), projectPOM, this.metadataService.getMetadata(module.getPomXMLPath()), "System updated dependencies from service task installation.", false);
                }
            }
            if (service.getGav() == null) {
                this.installFromLocal(service, module);
            } else {
                this.installFromJar(service, module);
            }
            String handler = service.getDefaultHandler();
            if (parameters != null && !parameters.isEmpty()) {
                String strParams = "(\"" + parameters.stream().collect(Collectors.joining("\", \"")) + "\")";
                handler = handler.replaceFirst("\\(.*?\\)", strParams);
            }
            this.serviceTaskResourceEvent.fire((Object)new ServiceTaskResourceEvent(path, "mvel", handler, service.getName(), "", ResourceChangeType.ADD));
            logger.info("Service task {} has been installed", (Object)service.getName());
        }
        catch (Exception e) {
            logger.error("Unexpected error when installing service task {}", (Object)service.getName(), (Object)e);
        }
    }

    public void onServiceTaskUninstalled(RepoData service, String target, String branchName) {
        String icon;
        org.uberfire.backend.vfs.Path path = this.getTargetPath("pom.xml", branchName, target);
        Module module = this.moduleService.resolveModule(path);
        POM projectPOM = (POM)this.pomService.load(module.getPomXMLPath());
        boolean installPomDepds = ((ServiceTasksConfiguration)this.repositoryStorage.loadConfiguration()).getInstallPomDeps();
        if (installPomDepds && projectPOM != null) {
            boolean useVersionRange = ((ServiceTasksConfiguration)this.repositoryStorage.loadConfiguration()).getVersionRange();
            Dependencies workItemDepends = new Dependencies();
            service.getMavenDependencies().forEach(dep -> workItemDepends.add(new Dependency(new GAV(dep.getGroupId(), dep.getArtifactId(), this.resolveVersion(dep.getVersion(), useVersionRange)))));
            if (workItemDepends != null && workItemDepends.size() > 0) {
                for (Dependency workitemDependency : workItemDepends) {
                    projectPOM.getDependencies().remove((Object)workitemDependency);
                }
                this.pomService.save(module.getPomXMLPath(), projectPOM, this.metadataService.getMetadata(module.getPomXMLPath()), "System updated dependencies from service task uninstallation.", false);
            }
        }
        if ((icon = service.getIcon()) != null && !icon.isEmpty()) {
            String iconName = service.getName() + ".png";
            org.uberfire.backend.vfs.Path iconPath = PathFactory.newPath((String)iconName, (String)(module.getRootPath().toURI() + "global/" + iconName));
            this.delete(Paths.convert((org.uberfire.backend.vfs.Path)iconPath));
        }
        org.uberfire.backend.vfs.Path widPath = PathFactory.newPath((String)(service.getName() + ".wid"), (String)(module.getRootPath().toURI() + "global/" + service.getName() + ".wid"));
        this.delete(Paths.convert((org.uberfire.backend.vfs.Path)widPath));
        this.serviceTaskResourceEvent.fire((Object)new ServiceTaskResourceEvent(path, "mvel", service.getDefaultHandler(), service.getName(), "", ResourceChangeType.DELETE));
        logger.info("Service task {} has been uninstalled", (Object)service.getName());
    }

    protected void installFromLocal(RepoData service, Module module) throws IOException {
        String icon = service.getIcon();
        if (icon != null && !icon.isEmpty()) {
            String iconLocation = REPOSITORY_CONTENT_LOCATION + service.getModule() + "/" + icon;
            InputStream stream = this.servletContext.getResourceAsStream(iconLocation);
            if (stream == null) {
                iconLocation = REPOSITORY_CONTENT_LOCATION + service.getModule() + "/icon.png";
                stream = this.servletContext.getResourceAsStream(iconLocation);
            }
            String iconName = service.getName() + ".png";
            org.uberfire.backend.vfs.Path iconPath = PathFactory.newPath((String)iconName, (String)(module.getRootPath().toURI() + "global/" + iconName));
            this.store(Paths.convert((org.uberfire.backend.vfs.Path)iconPath), IOUtils.toByteArray((InputStream)stream));
        }
        String widLocation = REPOSITORY_CONTENT_LOCATION + service.getModule() + "/" + service.getName() + ".wid";
        InputStream widStream = this.servletContext.getResourceAsStream(widLocation);
        org.uberfire.backend.vfs.Path widPath = PathFactory.newPath((String)(service.getName() + ".wid"), (String)(module.getRootPath().toURI() + "global/" + service.getName() + ".wid"));
        this.store(Paths.convert((org.uberfire.backend.vfs.Path)widPath), IOUtils.toByteArray((InputStream)widStream));
    }

    protected void installFromJar(RepoData service, Module module) throws IOException {
        File uploadedServiceArtifact = this.m2Repository.getArtifactFileFromRepository(new GAV(service.getGav()));
        if (uploadedServiceArtifact == null || !uploadedServiceArtifact.exists()) {
            throw new RuntimeException("No file found for artifact " + service.getGav());
        }
        try (ZipFile zipFile = new ZipFile(uploadedServiceArtifact);){
            String icon = service.getIcon();
            if (icon != null && !icon.isEmpty()) {
                ZipEntry location = zipFile.getEntry(icon);
                if (location == null) {
                    location = zipFile.getEntry("icon.png");
                }
                InputStream stream = zipFile.getInputStream(location);
                String iconName = service.getName() + ".png";
                org.uberfire.backend.vfs.Path iconPath = PathFactory.newPath((String)iconName, (String)(module.getRootPath().toURI() + "global/" + iconName));
                this.store(Paths.convert((org.uberfire.backend.vfs.Path)iconPath), IOUtils.toByteArray((InputStream)stream));
            }
            ZipEntry widLocation = zipFile.getEntry(service.getName() + ".wid");
            InputStream widStream = zipFile.getInputStream(widLocation);
            org.uberfire.backend.vfs.Path widPath = PathFactory.newPath((String)(service.getName() + ".wid"), (String)(module.getRootPath().toURI() + "global/" + service.getName() + ".wid"));
            this.store(Paths.convert((org.uberfire.backend.vfs.Path)widPath), IOUtils.toByteArray((InputStream)widStream));
        }
    }

    private Dependencies getValidDependenciesForWorkitem(Dependencies projectDepends, RepoData workitem, boolean useVersionRange) {
        Dependencies validDepends = new Dependencies();
        Dependencies workItemDepends = new Dependencies();
        workitem.getMavenDependencies().forEach(dep -> workItemDepends.add(new Dependency(new GAV(dep.getGroupId(), dep.getArtifactId(), this.resolveVersion(dep.getVersion(), useVersionRange)))));
        for (Dependency depends : workItemDepends) {
            if (projectDepends.containsDependency((GAV)depends)) continue;
            validDepends.add(depends);
        }
        return validDepends;
    }

    protected void store(Path path, byte[] content) {
        try {
            this.ioService.startBatch(path.getFileSystem());
            this.ioService.write(path, content, new OpenOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    protected void delete(Path path) {
        try {
            this.ioService.startBatch(path.getFileSystem());
            this.ioService.deleteIfExists(path, new DeleteOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    protected String resolveVersion(String version, boolean useVersionRange) {
        if (useVersionRange) {
            String[] versionElements = version.split("\\.");
            StringBuilder builder = new StringBuilder("[");
            builder.append(versionElements[0]);
            if (versionElements.length > 1) {
                try {
                    Integer minor = Integer.parseInt(versionElements[1]);
                    builder.append(".");
                    builder.append(minor);
                }
                catch (NumberFormatException e) {
                    logger.debug("Version element {} is not a number, ignoring", (Object)versionElements[1]);
                }
            }
            builder.append(",)");
            return builder.toString();
        }
        return version;
    }

    protected org.uberfire.backend.vfs.Path getTargetPath(String fileName, String branchName, String target) {
        if (branchName == null || branchName.trim().length() < 1) {
            branchName = "master";
        }
        return PathFactory.newPath((String)fileName, (String)("default://" + branchName + "@" + target));
    }
}

