/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.util;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class ClassUtils {
    private final Map<Class<?>, Class<?>> WRAPPER_MAP = new HashMap();
    private boolean initialized;

    public ClassUtils() {
        this.init();
    }

    @PostConstruct
    private void init() {
        if (this.initialized) {
            return;
        }
        this.WRAPPER_MAP.put(Boolean.class, Boolean.TYPE);
        this.WRAPPER_MAP.put(Byte.class, Byte.TYPE);
        this.WRAPPER_MAP.put(Character.class, Character.TYPE);
        this.WRAPPER_MAP.put(Short.class, Short.TYPE);
        this.WRAPPER_MAP.put(Integer.class, Integer.TYPE);
        this.WRAPPER_MAP.put(Long.class, Long.TYPE);
        this.WRAPPER_MAP.put(Double.class, Double.TYPE);
        this.WRAPPER_MAP.put(Float.class, Float.TYPE);
        this.WRAPPER_MAP.put(Void.class, Void.TYPE);
        this.initialized = true;
    }

    public static boolean isTypeOf(Class<?> type, Object instance) {
        return instance.getClass().getName().equals(type.getName());
    }

    public static String getName(Class<?> type) {
        return type.getName();
    }

    public static boolean isJavaRuntimeClassname(String fqcn) {
        return fqcn.startsWith("java");
    }

    public boolean isPrimitiveClass(Class<?> type) {
        return type.isPrimitive() || this.WRAPPER_MAP.containsKey(type);
    }
}

