/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.projects;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.kie.soup.project.datamodel.commons.oracle.ModuleDataModelOracleImpl;
import org.kie.soup.project.datamodel.oracle.Annotation;
import org.kie.soup.project.datamodel.oracle.MethodInfo;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.TypeSource;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.BaseFactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ClassFieldInspector;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ClassMethodInspector;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.FactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ModuleDataModelOracleBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.AnnotationUtils;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.DenyLists;

public class ClassFactBuilder
extends BaseFactBuilder {
    private final Map<String, List<MethodInfo>> methodInformation = new HashMap<String, List<MethodInfo>>();
    private final Map<String, String> fieldParametersType = new HashMap<String, String>();
    private final List<String> superTypes;
    private final Set<Annotation> annotations = new LinkedHashSet<Annotation>();
    private final Map<String, Set<Annotation>> fieldAnnotations = new HashMap<String, Set<Annotation>>();
    private final Map<String, FactBuilder> fieldFactBuilders = new HashMap<String, FactBuilder>();

    public ClassFactBuilder(ModuleDataModelOracleBuilder builder, Class<?> clazz, boolean isEvent, Function<String, TypeSource> typeSourceResolver) throws IOException {
        this(builder, new HashMap<String, FactBuilder>(), clazz, isEvent, typeSourceResolver);
    }

    public ClassFactBuilder(ModuleDataModelOracleBuilder builder, Map<String, FactBuilder> discoveredFieldFactBuilders, Class<?> clazz, boolean isEvent, Function<String, TypeSource> typeSourceResolver) throws IOException {
        super(builder, clazz, isEvent, typeSourceResolver);
        this.superTypes = this.getSuperTypes(clazz);
        this.annotations.addAll(AnnotationUtils.getClassAnnotations(clazz));
        this.loadClassFields(clazz, discoveredFieldFactBuilders);
    }

    @Override
    public void build(ModuleDataModelOracleImpl oracle) {
        super.build(oracle);
        oracle.addModuleMethodInformation(this.methodInformation);
        oracle.addModuleFieldParametersType(this.fieldParametersType);
        oracle.addModuleSuperTypes(this.buildSuperTypes());
        oracle.addModuleTypeAnnotations(this.buildTypeAnnotations());
        oracle.addModuleTypeFieldsAnnotations(this.buildTypeFieldsAnnotations());
    }

    private List<String> getSuperTypes(Class<?> clazz) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Class<?> superType = clazz.getSuperclass(); superType != null; superType = superType.getSuperclass()) {
            strings.add(superType.getName());
        }
        return strings;
    }

    private void loadClassFields(Class<?> clazz, Map<String, FactBuilder> discoveredFieldFactBuilders) throws IOException {
        if (clazz == null) {
            return;
        }
        String factType = this.getType();
        ClassFieldInspector inspector = new ClassFieldInspector(clazz);
        Set<String> fieldNames = inspector.getFieldNames();
        for (String fieldName : fieldNames) {
            Set<Annotation> fieldAnnotations;
            ClassFieldInspector.FieldInfo f = inspector.getFieldTypesFieldInfo().get(fieldName);
            this.addParametricTypeForField(factType, fieldName, f.getGenericType());
            Class<?> returnType = f.getReturnType();
            String genericReturnType = this.typeSystemConverter.translateClassToGenericType(returnType);
            this.addField(new ModelField(fieldName, returnType.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, f.getOrigin(), f.getAccessorAndMutator(), genericReturnType));
            this.addEnumsForField(factType, fieldName, returnType);
            if (DenyLists.isReturnTypeInDenyList(returnType)) continue;
            this.discoverFieldFactBuilder(genericReturnType, returnType, discoveredFieldFactBuilders);
            if (f.getGenericType() instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)f.getGenericType();
                for (Type parameterType : parameterizedType.getActualTypeArguments()) {
                    if (discoveredFieldFactBuilders.containsKey(parameterType.getTypeName()) || !(parameterType instanceof Class)) continue;
                    Class parameterClazz = (Class)parameterType;
                    this.discoverFieldFactBuilder(parameterClazz.getName(), parameterClazz, discoveredFieldFactBuilders);
                }
            }
            if ((fieldAnnotations = f.getAnnotations()) == null || fieldAnnotations.isEmpty()) continue;
            this.fieldAnnotations.put(fieldName, f.getAnnotations());
        }
        ClassMethodInspector methodInspector = new ClassMethodInspector(clazz, this.typeSystemConverter);
        List<MethodInfo> methodInformation = methodInspector.getMethodInfos();
        for (MethodInfo mi : methodInformation) {
            String genericType = mi.getParametricReturnType();
            if (genericType == null) continue;
            String qualifiedFactFieldName = factType + "#" + mi.getNameWithParameters();
            this.fieldParametersType.put(qualifiedFactFieldName, genericType);
        }
        this.methodInformation.put(factType, methodInformation);
    }

    protected void discoverFieldFactBuilder(String genericTypeName, Class<?> genericType, Map<String, FactBuilder> discoveredFieldFactBuilders) throws IOException {
        if (!discoveredFieldFactBuilders.containsKey(genericTypeName)) {
            discoveredFieldFactBuilders.put(genericTypeName, null);
            discoveredFieldFactBuilders.put(genericTypeName, new ClassFactBuilder(this.builder, discoveredFieldFactBuilders, genericType, false, (Function<String, TypeSource>)this.typeSourceResolver));
        }
        if (discoveredFieldFactBuilders.get(genericTypeName) != null) {
            this.fieldFactBuilders.put(genericTypeName, discoveredFieldFactBuilders.get(genericTypeName));
        }
    }

    private void addEnumsForField(String className, String fieldName, Class<?> fieldClazz) {
        if (fieldClazz.isEnum()) {
            Field[] enumFields = fieldClazz.getDeclaredFields();
            ArrayList<String> enumValues = new ArrayList<String>();
            for (Field enumField : enumFields) {
                if (!enumField.isEnumConstant()) continue;
                String shortName = fieldClazz.getName().substring(fieldClazz.getName().lastIndexOf(".") + 1) + "." + enumField.getName();
                if (shortName.contains("$")) {
                    shortName = shortName.replaceAll("\\$", ".");
                }
                enumValues.add(shortName + "=" + shortName);
            }
            String[] a = new String[enumValues.size()];
            enumValues.toArray(a);
            this.getDataModelBuilder().addEnum(className, fieldName, a);
        }
    }

    private void addParametricTypeForField(String className, String fieldName, Type type) {
        String qualifiedFactFieldName = className + "#" + fieldName;
        String parametricType = this.getParametricType(type);
        if (parametricType != null) {
            this.fieldParametersType.put(qualifiedFactFieldName, parametricType);
        }
    }

    private String getParametricType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type parameter = null;
            Type[] typeArray = pt.getActualTypeArguments();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type t;
                parameter = t = typeArray[i];
            }
            if (parameter != null) {
                if (parameter instanceof Class) {
                    return ((Class)parameter).getName();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private Map<String, List<String>> buildSuperTypes() {
        HashMap<String, List<String>> loadableSuperTypes = new HashMap<String, List<String>>();
        loadableSuperTypes.put(this.getType(), this.superTypes);
        return loadableSuperTypes;
    }

    private Map<String, Set<Annotation>> buildTypeAnnotations() {
        HashMap<String, Set<Annotation>> loadableTypeAnnotations = new HashMap<String, Set<Annotation>>();
        loadableTypeAnnotations.put(this.getType(), this.annotations);
        return loadableTypeAnnotations;
    }

    private Map<String, Map<String, Set<Annotation>>> buildTypeFieldsAnnotations() {
        HashMap<String, Map<String, Set<Annotation>>> loadableTypeFieldsAnnotations = new HashMap<String, Map<String, Set<Annotation>>>();
        loadableTypeFieldsAnnotations.put(this.getType(), this.fieldAnnotations);
        return loadableTypeFieldsAnnotations;
    }

    @Override
    public void addInternalBuilders(Map<String, FactBuilder> builders) {
        this.fieldFactBuilders.entrySet().stream().filter(e -> !builders.containsKey(e.getKey())).forEach(entry -> {
            builders.put((String)entry.getKey(), (FactBuilder)entry.getValue());
            ((FactBuilder)entry.getValue()).addInternalBuilders(builders);
        });
    }
}

