/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.internal.util.DefaultOptions;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.constant.HaMode;

public class UrlParser {
    private String database;
    private Options options = null;
    private List<HostAddress> addresses;
    private HaMode haMode;

    private UrlParser() {
    }

    protected UrlParser(String database, List<HostAddress> addresses, Options options, HaMode haMode) throws SQLException {
        this.options = options;
        this.database = database;
        this.addresses = addresses;
        this.haMode = haMode;
        if (haMode == HaMode.AURORA) {
            for (HostAddress hostAddress : addresses) {
                hostAddress.type = null;
            }
        } else {
            for (HostAddress hostAddress : addresses) {
                if (hostAddress.type != null) continue;
                hostAddress.type = "master";
            }
        }
    }

    public static boolean acceptsUrl(String url) {
        return url != null && (url.startsWith("jdbc:mariadb:") || url.startsWith("jdbc:mysql:"));
    }

    public static UrlParser parse(String url) throws SQLException {
        return UrlParser.parse(url, new Properties());
    }

    public static UrlParser parse(String url, Properties prop) throws SQLException {
        if (url != null) {
            if (prop == null) {
                prop = new Properties();
            }
            if (url.startsWith("jdbc:mysql:")) {
                UrlParser urlParser = new UrlParser();
                UrlParser.parseInternal(urlParser, url, prop);
                return urlParser;
            }
            if (url.startsWith("jdbc:mariadb:")) {
                UrlParser urlParser = new UrlParser();
                UrlParser.parseInternal(urlParser, "jdbc:mysql:" + url.substring(13), prop);
                return urlParser;
            }
        }
        return null;
    }

    private static void parseInternal(UrlParser urlParser, String url, Properties properties) throws SQLException {
        try {
            int separator = url.indexOf("//");
            if (separator == -1) {
                throw new IllegalArgumentException("url parsing error : '//' is not present in the url " + url);
            }
            UrlParser.setHaMode(urlParser, url, separator);
            String urlSecondPart = url.substring(separator + 2);
            String[] tokens = urlSecondPart.split("/");
            String hostAddressesString = tokens[0];
            String additionalParameters = tokens.length > 1 ? urlSecondPart.substring(tokens[0].length() + 1) : null;
            urlParser.addresses = HostAddress.parse(hostAddressesString, urlParser.haMode);
            if (additionalParameters == null) {
                urlParser.database = null;
                urlParser.options = DefaultOptions.parse(urlParser.haMode, "", properties);
            } else {
                int ind = additionalParameters.indexOf(63);
                if (ind > -1) {
                    urlParser.database = additionalParameters.substring(0, ind);
                    urlParser.options = DefaultOptions.parse(urlParser.haMode, additionalParameters.substring(ind + 1), properties);
                } else {
                    if (!"".equals(additionalParameters)) {
                        urlParser.database = additionalParameters;
                    }
                    urlParser.options = DefaultOptions.parse(urlParser.haMode, "", properties, urlParser.options);
                }
            }
            UrlParser.setDefaultHostAddressType(urlParser);
        }
        catch (IllegalArgumentException i) {
            throw new SQLException(i.getMessage());
        }
    }

    private static void setHaMode(UrlParser urlParser, String url, int separator) {
        String[] baseTokens = url.substring(0, separator).split(":");
        urlParser.haMode = HaMode.NONE;
        if (baseTokens.length > 2) {
            try {
                urlParser.haMode = HaMode.valueOf(baseTokens[2].toUpperCase());
            }
            catch (IllegalArgumentException i) {
                throw new IllegalArgumentException("url parameter error '" + baseTokens[2] + "' is a unknown parameter in the url " + url);
            }
        }
    }

    private static void setDefaultHostAddressType(UrlParser urlParser) {
        if (urlParser.haMode == HaMode.AURORA) {
            for (HostAddress hostAddress : urlParser.addresses) {
                hostAddress.type = null;
            }
        } else {
            for (HostAddress hostAddress : urlParser.addresses) {
                if (hostAddress.type != null) continue;
                hostAddress.type = "master";
            }
        }
    }

    public void parseUrl(String url) throws SQLException {
        String[] arr;
        if (url.startsWith("jdbc:mysql:")) {
            UrlParser.parseInternal(this, url, new Properties());
            return;
        }
        for (String prefix : arr = new String[]{"jdbc:mysql:thin:", "jdbc:mariadb:"}) {
            if (!url.startsWith(prefix)) continue;
            UrlParser.parseInternal(this, "jdbc:mysql:" + url.substring(prefix.length()), new Properties());
            break;
        }
    }

    public String getUsername() {
        return this.options.user;
    }

    protected void setUsername(String username) {
        this.options.user = username;
    }

    public String getPassword() {
        return this.options.password;
    }

    protected void setPassword(String password) {
        this.options.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    protected void setDatabase(String database) {
        this.database = database;
    }

    public List<HostAddress> getHostAddresses() {
        return this.addresses;
    }

    public Options getOptions() {
        return this.options;
    }

    protected void setProperties(String urlParameters) {
        DefaultOptions.parse(this.haMode, urlParameters, this.options);
    }

    public String toString() {
        String str = "jdbc:mysql://";
        if (!this.haMode.equals((Object)HaMode.NONE)) {
            str = "jdbc:mysql:" + this.haMode.toString().toLowerCase() + "://";
        }
        if (this.addresses != null) {
            str = str + HostAddress.toString(this.addresses);
        }
        if (this.database != null) {
            str = str + "/" + this.database;
        }
        return str;
    }

    public HaMode getHaMode() {
        return this.haMode;
    }

    public boolean equals(Object parser) {
        if (this == parser) {
            return true;
        }
        if (!(parser instanceof UrlParser)) {
            return false;
        }
        UrlParser urlParser = (UrlParser)parser;
        if (this.getDatabase() != null ? !this.getDatabase().equals(urlParser.getDatabase()) : urlParser.getDatabase() != null) {
            return false;
        }
        if (this.getOptions() != null ? !this.getOptions().equals(urlParser.getOptions()) : urlParser.getOptions() != null) {
            return false;
        }
        if (this.addresses != null ? !this.addresses.equals(urlParser.addresses) : urlParser.addresses != null) {
            return false;
        }
        return this.getHaMode() == urlParser.getHaMode();
    }
}

