/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.backend.server;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.workbench.es.backend.server.ExecutionErrorSummaryMapper;
import org.jbpm.workbench.es.backend.server.RequestDetailsMapper;
import org.jbpm.workbench.es.model.ExecutionErrorSummary;
import org.jbpm.workbench.es.model.RequestDetails;
import org.jbpm.workbench.es.service.ExecutorService;
import org.jbpm.workbench.ks.integration.AbstractKieServerService;
import org.kie.server.api.model.admin.ExecutionErrorInstance;
import org.kie.server.api.model.instance.JobRequestInstance;
import org.kie.server.api.model.instance.RequestInfoInstance;
import org.kie.server.client.JobServicesClient;
import org.kie.server.client.admin.ProcessAdminServicesClient;

@Service
@ApplicationScoped
public class RemoteExecutorServiceImpl
extends AbstractKieServerService
implements ExecutorService {
    public RequestDetails getRequestDetails(String serverTemplateId, String deploymentId, Long requestId) {
        JobServicesClient jobClient = null;
        jobClient = deploymentId != null && !deploymentId.isEmpty() ? (JobServicesClient)this.getClient(serverTemplateId, deploymentId, JobServicesClient.class) : (JobServicesClient)this.getClient(serverTemplateId, JobServicesClient.class);
        Optional<RequestInfoInstance> request = Optional.ofNullable(jobClient.getRequestById(deploymentId, requestId, true, true));
        return request.map(new RequestDetailsMapper()).orElse(null);
    }

    public Long scheduleRequest(String serverTemplateId, String commandName, Date date, Map<String, String> ctx) {
        JobServicesClient jobClient = (JobServicesClient)this.getClient(serverTemplateId, JobServicesClient.class);
        HashMap<Object, Object> data = new HashMap();
        if (ctx != null && !ctx.isEmpty()) {
            data = new HashMap<String, String>(ctx);
        }
        JobRequestInstance jobRequest = JobRequestInstance.builder().command(commandName).data(data).scheduledDate(date).build();
        return jobClient.scheduleRequest((String)data.get("containerId"), jobRequest);
    }

    public void cancelRequest(String serverTemplateId, String deploymentId, Long requestId) {
        JobServicesClient jobClient = (JobServicesClient)this.getClient(serverTemplateId, JobServicesClient.class);
        jobClient.cancelRequest(deploymentId, requestId.longValue());
    }

    public void requeueRequest(String serverTemplateId, String deploymentId, Long requestId) {
        JobServicesClient jobClient = (JobServicesClient)this.getClient(serverTemplateId, JobServicesClient.class);
        jobClient.requeueRequest(deploymentId, requestId.longValue());
    }

    public void acknowledgeError(String serverTemplateId, String deploymentId, String ... errorId) {
        ProcessAdminServicesClient processAdminServicesClient = (ProcessAdminServicesClient)this.getClient(serverTemplateId, ProcessAdminServicesClient.class);
        processAdminServicesClient.acknowledgeError(deploymentId, errorId);
    }

    public ExecutionErrorSummary getError(String serverTemplateId, String deploymentId, String errorId) {
        ProcessAdminServicesClient processAdminServicesClient = (ProcessAdminServicesClient)this.getClient(serverTemplateId, ProcessAdminServicesClient.class);
        Optional<ExecutionErrorInstance> executionErrorInstance = Optional.ofNullable(processAdminServicesClient.getError(deploymentId, errorId));
        return executionErrorInstance.map(new ExecutionErrorSummaryMapper()).orElse(null);
    }
}

