/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.List;
import org.dmg.pmml.Field;
import org.dmg.pmml.scorecard.Attribute;
import org.dmg.pmml.scorecard.Characteristic;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.scorecard.compiler.factories.KiePMMLAttributeFactory;

public class KiePMMLCharacteristicFactory {
    static final String KIE_PMML_CHARACTERISTIC_TEMPLATE_JAVA = "KiePMMLCharacteristicTemplate.tmpl";
    static final String KIE_PMML_CHARACTERISTIC_TEMPLATE = "KiePMMLCharacteristicTemplate";
    static final String GETKIEPMMLCHARACTERISTIC = "getKiePMMLCharacteristic";
    static final String CHARACTERISTIC = "characteristic";
    static final ClassOrInterfaceDeclaration CHARACTERISTIC_TEMPLATE;

    private KiePMMLCharacteristicFactory() {
    }

    static BlockStmt getCharacteristicVariableDeclaration(String variableName, Characteristic characteristic, List<Field<?>> fields) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)CHARACTERISTIC_TEMPLATE.getMethodsByName(GETKIEPMMLCHARACTERISTIC).get(0)).clone();
        BlockStmt characteristicBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = (VariableDeclarator)CommonCodegenUtils.getVariableDeclarator((BlockStmt)characteristicBody, (String)CHARACTERISTIC).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", CHARACTERISTIC, characteristicBody)));
        variableDeclarator.setName(variableName);
        BlockStmt toReturn = new BlockStmt();
        int counter = 0;
        NodeList arguments = new NodeList();
        for (Attribute attribute : characteristic.getAttributes()) {
            String attributeVariableName = String.format("%s_%s", variableName, counter);
            BlockStmt toAdd = KiePMMLAttributeFactory.getAttributeVariableDeclaration(attributeVariableName, attribute, fields);
            toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
            arguments.add((Node)new NameExpr(attributeVariableName));
            ++counter;
        }
        MethodCallExpr initializer = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", CHARACTERISTIC, characteristicBody)))).asMethodCallExpr();
        MethodCallExpr builder = CommonCodegenUtils.getChainedMethodCallExprFrom((String)"builder", (MethodCallExpr)initializer);
        builder.setArgument(0, (Expression)new StringLiteralExpr(variableName));
        builder.setArgument(2, (Expression)CommonCodegenUtils.getArraysAsListInvocationMethodCall((NodeList)arguments));
        CommonCodegenUtils.getChainedMethodCallExprFrom((String)"withBaselineScore", (MethodCallExpr)initializer).setArgument(0, CommonCodegenUtils.getExpressionForObject((Object)characteristic.getBaselineScore()));
        CommonCodegenUtils.getChainedMethodCallExprFrom((String)"withReasonCode", (MethodCallExpr)initializer).setArgument(0, CommonCodegenUtils.getExpressionForObject((Object)characteristic.getReasonCode()));
        characteristicBody.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName((String)KIE_PMML_CHARACTERISTIC_TEMPLATE_JAVA);
        CHARACTERISTIC_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_CHARACTERISTIC_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLCharacteristicTemplate"));
        ((MethodDeclaration)CHARACTERISTIC_TEMPLATE.getMethodsByName(GETKIEPMMLCHARACTERISTIC).get(0)).clone();
    }
}

