/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.executor;

import java.util.Optional;
import javax.inject.Inject;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.exceptions.ProvisioningException;
import org.guvnor.ala.pipeline.FunctionConfigExecutor;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderBuilder;
import org.guvnor.ala.runtime.providers.ProviderDestroyer;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.wildfly.config.WildflyProviderConfig;
import org.guvnor.ala.wildfly.config.impl.WildflyProviderConfigImpl;
import org.guvnor.ala.wildfly.model.WildflyProvider;
import org.guvnor.ala.wildfly.model.WildflyProviderImpl;

public class WildflyProviderConfigExecutor
implements ProviderBuilder<WildflyProviderConfig, WildflyProvider>,
ProviderDestroyer,
FunctionConfigExecutor<WildflyProviderConfig, WildflyProvider> {
    private RuntimeRegistry runtimeRegistry;

    @Inject
    public WildflyProviderConfigExecutor(RuntimeRegistry runtimeRegistry) {
        this.runtimeRegistry = runtimeRegistry;
    }

    public Optional<WildflyProvider> apply(WildflyProviderConfig wildflyProviderConfig) {
        WildflyProvider wildflyProvider;
        if (wildflyProviderConfig.getName() == null || wildflyProviderConfig.getName().isEmpty()) {
            throw new ProvisioningException("No name was provided for the WildflyProviderConfig.getName() configuration parameter. You might probably have to properly set the pipeline input parameter: provider-name");
        }
        Provider provider = this.runtimeRegistry.getProvider(wildflyProviderConfig.getName());
        if (provider != null) {
            if (!(provider instanceof WildflyProvider)) {
                throw new ProvisioningException("The provider: " + wildflyProviderConfig.getName() + " must be an instance of " + WildflyProviderConfig.class + " but is: " + provider.getClass());
            }
            wildflyProvider = (WildflyProvider)provider;
        } else {
            wildflyProvider = new WildflyProviderImpl(new WildflyProviderConfigImpl(wildflyProviderConfig.getName(), wildflyProviderConfig.getHost(), wildflyProviderConfig.getPort(), wildflyProviderConfig.getManagementPort(), wildflyProviderConfig.getUser(), wildflyProviderConfig.getPassword()));
            this.runtimeRegistry.registerProvider((Provider)wildflyProvider);
        }
        return Optional.of(wildflyProvider);
    }

    public Class<? extends Config> executeFor() {
        return WildflyProviderConfig.class;
    }

    public String outputId() {
        return "wildfly-provider";
    }

    public boolean supports(ProviderConfig config) {
        return config instanceof WildflyProviderConfig;
    }

    public boolean supports(ProviderId providerId) {
        return providerId instanceof WildflyProvider;
    }

    public void destroy(ProviderId providerId) {
    }
}

