/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.definition.property.notification;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.jboss.errai.databinding.client.api.Bindable;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Portable
@Bindable
public class NotificationValue {
    private String body = "";
    private String expiresAt = "";
    private String from = "";
    private List<String> groups;
    private String replyTo = "";
    private String subject = "";
    private List<String> users;
    private String emails = "";
    private String type = "";

    public NotificationValue() {
        this.groups = new ArrayList<String>();
        this.users = new ArrayList<String>();
    }

    public NotificationValue(@MapsTo(value="body") String body, @MapsTo(value="expiresAt") String expiresAt, @MapsTo(value="subject") String subject, @MapsTo(value="replyTo") String replyTo, @MapsTo(value="type") String type, @MapsTo(value="from") String from, @MapsTo(value="togroups") List<String> groups, @MapsTo(value="tousers") List<String> users, @MapsTo(value="emails") String emails) {
        this.body = body;
        this.expiresAt = expiresAt;
        this.subject = subject;
        this.replyTo = replyTo;
        this.type = type;
        this.from = from;
        this.groups = groups;
        this.users = users;
        this.emails = emails;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public void setUsers(List<String> users) {
        this.users = users;
    }

    public String getEmails() {
        return this.emails;
    }

    public void setEmails(String emails) {
        this.emails = emails;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String toCDATAFormat() {
        return "[from:" + this.from + "|tousers:" + String.join((CharSequence)",", this.users) + "|togroups:" + String.join((CharSequence)",", this.groups) + "|toemails:" + this.emails + "|replyTo:" + this.replyTo + "|subject:" + NotificationValue.replaceAsciiSymbols(this.subject) + "|body:" + NotificationValue.replaceAsciiSymbols(this.body) + "]@[" + this.expiresAt + "]";
    }

    private static String replaceAsciiSymbols(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("\\|", "&#124;").replaceAll("\\^", "&#94;");
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{Objects.hashCode(this.body), Objects.hashCode(this.expiresAt), Objects.hashCode(this.from), Objects.hashCode(this.type), Objects.hashCode(this.users), Objects.hashCode(this.groups), Objects.hashCode(this.emails), Objects.hashCode(this.replyTo), Objects.hashCode(this.subject)});
    }

    public boolean equals(Object o) {
        if (o instanceof NotificationValue) {
            NotificationValue other = (NotificationValue)o;
            return Objects.equals(this.body, other.body) && Objects.equals(this.expiresAt, other.expiresAt) && Objects.equals(this.from, other.from) && Objects.equals(this.subject, other.subject) && Objects.equals(this.type, other.type) && Objects.equals(this.groups, other.groups) && Objects.equals(this.emails, other.emails) && Objects.equals(this.users, other.users) && Objects.equals(this.replyTo, other.replyTo);
        }
        return false;
    }

    public String toString() {
        return "Notification{ type='" + this.type + '\'' + ", from='" + this.from + '\'' + ", replyTo='" + this.replyTo + '\'' + ", subject='" + this.subject + '\'' + ", body='" + this.body + '\'' + ", expiresAt='" + this.expiresAt + '\'' + ", users='" + String.join((CharSequence)", ", this.users) + '\'' + ", groups='" + String.join((CharSequence)", ", this.groups) + '\'' + ", emails='" + this.emails + '\'' + '}';
    }
}

