/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.model;

import java.util.List;
import org.kie.pmml.api.exceptions.KiePMMLValidationException;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;

public class KiePMMLScoreDistribution
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = -8674575012261916224L;
    private final String value;
    private final int recordCount;
    private final Double confidence;
    private final Double probability;

    public KiePMMLScoreDistribution(String name, List<KiePMMLExtension> extensions, String value, int recordCount, Double confidence, Double probability) {
        super(name, extensions);
        this.value = value;
        this.recordCount = recordCount;
        this.confidence = confidence;
        this.probability = probability;
    }

    public boolean hasProbability() {
        return this.probability != null;
    }

    public String getValue() {
        return this.value;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public double getProbability() {
        if (this.probability == null) {
            throw new KiePMMLValidationException("Missing expected probability");
        }
        return this.probability;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public double getEvaluatedProbability(int totalRecordCount) {
        return (double)this.recordCount / (double)totalRecordCount;
    }

    public Double getEvaluatedConfidence(double missingValuePenalty) {
        return this.confidence != null ? Double.valueOf(this.confidence * missingValuePenalty) : null;
    }
}

