/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ifttt;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="IFTTTDefinitions.wid", name="IFTTTCall", displayName="IFTTTCall", defaultHandler="mvel: new org.jbpm.process.workitem.ifttt.IFTTTWorkitemHandler(\"key\")", documentation="ifttt-workitem/index.html", category="ifttt-workitem", icon="IFTTTCall.png", parameters={@WidParameter(name="Trigger", required=true), @WidParameter(name="Value1"), @WidParameter(name="Value2"), @WidParameter(name="Value3")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="ifttt-workitem", version="7.72.0.Final")}, serviceInfo=@WidService(category="IFTTT", description="Send a trigger message via IFTTT", keywords="ifttt,trigger,endpoint", action=@WidAction(title="Trigger an IFTTT endpoint"), authinfo=@WidAuth(required=true, params={"key"}, paramsdescription={"IFTTT app key"}, referencesite="https://platform.ifttt.com/docs/api_reference")))
public class IFTTTWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(IFTTTWorkitemHandler.class);
    private static final String IFTTT_TRIGGER_ENDPOINT = "https://maker.ifttt.com/trigger/%s/with/key/%s";
    private String key;
    private Client client;
    private IFTTTRequest iftttRequest;

    public IFTTTWorkitemHandler(String key) {
        this.key = key;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String trigger = (String)workItem.getParameter("Trigger");
            String valueOne = (String)workItem.getParameter("Value1");
            String valueTwo = (String)workItem.getParameter("Value2");
            String valueThree = (String)workItem.getParameter("Value3");
            if (this.client == null) {
                this.client = ClientBuilder.newClient();
            }
            WebTarget target = this.client.target(String.format(IFTTT_TRIGGER_ENDPOINT, trigger, this.key));
            this.iftttRequest = new IFTTTRequest(valueOne, valueTwo, valueThree);
            target.request().post(Entity.entity((Object)this.iftttRequest.toJSON(), (String)"application/json"), String.class);
            workItemManager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public String getRequestBody() {
        return this.iftttRequest.toJSON();
    }

    private class IFTTTRequest {
        private String value1;
        private String value2;
        private String value3;

        public IFTTTRequest(String value1, String value2, String value3) {
            this.value1 = StringUtils.isNotEmpty((CharSequence)value1) ? value1 : null;
            this.value2 = StringUtils.isNotEmpty((CharSequence)value2) ? value2 : null;
            this.value3 = StringUtils.isNotEmpty((CharSequence)value3) ? value3 : null;
        }

        public String toJSON() {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writeValueAsString((Object)this);
            }
            catch (IOException e) {
                logger.error("Unable to map values to JSON : " + e.getMessage());
                return null;
            }
        }

        public String getValue1() {
            return this.value1;
        }

        public void setValue1(String value1) {
            this.value1 = value1;
        }

        public String getValue2() {
            return this.value2;
        }

        public void setValue2(String value2) {
            this.value2 = value2;
        }

        public String getValue3() {
            return this.value3;
        }

        public void setValue3(String value3) {
            this.value3 = value3;
        }
    }
}

