/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DenyLists {
    public static boolean isClassMethodInDenyList(Class<?> clazz, String methodName) {
        if (DenyLists.isInObjectMethodsDenyList(methodName)) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz) && DenyLists.isInCollectionMethodsDenyList(methodName)) {
            return true;
        }
        if (Set.class.isAssignableFrom(clazz) && DenyLists.isInSetMethodsDenyList(methodName)) {
            return true;
        }
        if (List.class.isAssignableFrom(clazz) && DenyLists.isInListMethodsDenyList(methodName)) {
            return true;
        }
        return Map.class.isAssignableFrom(clazz) && DenyLists.isInMapMethodsDenyList(methodName);
    }

    private static boolean isInObjectMethodsDenyList(String methodName) {
        return "wait".equals(methodName) || "notify".equals(methodName) || "notifyAll".equals(methodName) || "class".equals(methodName) || "hashCode".equals(methodName) || "equals".equals(methodName) || "toString".equals(methodName);
    }

    private static boolean isInCollectionMethodsDenyList(String methodName) {
        return "addAll".equals(methodName) || "containsAll".equals(methodName) || "iterator".equals(methodName) || "removeAll".equals(methodName) || "retainAll".equals(methodName) || "toArray".equals(methodName);
    }

    private static boolean isInSetMethodsDenyList(String methodName) {
        return DenyLists.isInCollectionMethodsDenyList(methodName);
    }

    private static boolean isInListMethodsDenyList(String methodName) {
        return DenyLists.isInCollectionMethodsDenyList(methodName) || "listIterator".equals(methodName) || "subList".equals(methodName);
    }

    private static boolean isInMapMethodsDenyList(String methodName) {
        return "entrySet".equals(methodName) || "keySet".equals(methodName) || "putAll".equals(methodName);
    }

    public static boolean isTypeInDenyList(Class<?> type) {
        return type.isArray();
    }

    public static boolean isReturnTypeInDenyList(Class<?> type) {
        return type.isArray() || type.isPrimitive();
    }
}

