/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.access.impl;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.TlsVersion;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.openshift.access.OpenShiftAccessInterface;
import org.guvnor.ala.openshift.access.OpenShiftClient;
import org.guvnor.ala.openshift.config.OpenShiftProviderConfig;
import org.guvnor.ala.openshift.model.OpenShiftProvider;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.kie.soup.commons.validation.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.lifecycle.Disposable;

public class OpenShiftAccessInterfaceImpl
implements OpenShiftAccessInterface,
Disposable {
    protected static final Logger LOG = LoggerFactory.getLogger(OpenShiftAccessInterfaceImpl.class);
    private final Map<String, OpenShiftClient> clientMap = new ConcurrentHashMap<String, OpenShiftClient>();

    @Override
    public OpenShiftClient getOpenShiftClient(ProviderId providerId) {
        if (!this.clientMap.containsKey(providerId.getId())) {
            Preconditions.checkInstanceOf((String)"providerId", (Object)providerId, OpenShiftProvider.class);
            ProviderConfig providerConfig = ((OpenShiftProvider)providerId).getConfig();
            OpenShiftClient client = this.newOpenShiftClient(providerConfig);
            this.clientMap.put(providerId.getId(), client);
        }
        return this.clientMap.get(providerId.getId());
    }

    @Override
    public OpenShiftClient newOpenShiftClient(ProviderConfig providerConfig) {
        Preconditions.checkInstanceOf((String)"providerConfig", (Object)providerConfig, OpenShiftProviderConfig.class);
        OpenShiftConfig clientConfig = OpenShiftAccessInterfaceImpl.buildOpenShiftConfig((OpenShiftProviderConfig)providerConfig);
        return new OpenShiftClient((io.fabric8.openshift.client.OpenShiftClient)new DefaultOpenShiftClient(clientConfig));
    }

    static OpenShiftConfig buildOpenShiftConfig(OpenShiftProviderConfig config) {
        String openshiftUrl;
        String openshiftBuildTimeout;
        String kubernetesOapiVersion;
        String proxyUsername;
        String proxyPassword;
        String noProxy;
        String kubernetesWebsocketTimeout;
        String kubernetesWebsocketPingInterval;
        String kubernetesWatchReconnectLimit;
        String kubernetesWatchReconnectInterval;
        String kubernetesUserAgent;
        String kubernetesTruststorePassphrase;
        String kubernetesTruststoreFile;
        String kubernetesTrustCertificates;
        String kubernetesTlsVersions;
        String kubernetesScaleTimeout;
        String kubernetesRollingTimeout;
        String kubernetesRequestTimeout;
        String kubernetesNamespace;
        String kubernetesMain;
        String kubernetesLoggingInterval;
        String kubernetesKeystorePassphrase;
        String kubernetesKeystoreFile;
        String kubernetesConnectionTimeout;
        String kubernetesCertsClientKeyPassphrase;
        String kubernetesCertsClientKeyFile;
        String kubernetesCertsClientKeyData;
        String kubernetesCertsClientKeyAlgo;
        String kubernetesCertsClientFile;
        String kubernetesCertsClientData;
        String kubernetesCertsCaFile;
        String kubernetesCertsCaData;
        String kubernetesAuthToken;
        String kubernetesAuthBasicUsername;
        String kubernetesAuthBasicPassword;
        String kubernetesApiVersion;
        String httpsProxy;
        String httpProxy;
        OpenShiftConfigBuilder builder = new OpenShiftConfigBuilder(OpenShiftConfig.wrap((Config)Config.autoConfigure(null)));
        String allProxy = OpenShiftAccessInterfaceImpl.trimToNull(config.getAllProxy());
        if (allProxy != null) {
            builder = (OpenShiftConfigBuilder)builder.withHttpProxy(allProxy);
            builder = (OpenShiftConfigBuilder)builder.withHttpsProxy(allProxy);
        }
        if ((httpProxy = OpenShiftAccessInterfaceImpl.trimToNull(config.getHttpProxy())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withHttpProxy(httpProxy);
        }
        if ((httpsProxy = OpenShiftAccessInterfaceImpl.trimToNull(config.getHttpsProxy())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withHttpsProxy(httpsProxy);
        }
        if ((kubernetesApiVersion = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesApiVersion())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withApiVersion(kubernetesApiVersion);
        }
        if ((kubernetesAuthBasicPassword = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesAuthBasicPassword())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withPassword(kubernetesAuthBasicPassword);
        }
        if ((kubernetesAuthBasicUsername = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesAuthBasicUsername())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withUsername(kubernetesAuthBasicUsername);
        }
        if ((kubernetesAuthToken = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesAuthToken())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withOauthToken(kubernetesAuthToken);
        }
        if ((kubernetesCertsCaData = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesCertsCaData())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withCaCertData(kubernetesCertsCaData);
        }
        if ((kubernetesCertsCaFile = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesCertsCaFile())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withCaCertFile(kubernetesCertsCaFile);
        }
        if ((kubernetesCertsClientData = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesCertsClientData())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withClientCertData(kubernetesCertsClientData);
        }
        if ((kubernetesCertsClientFile = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesCertsClientFile())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withClientCertFile(kubernetesCertsClientFile);
        }
        if ((kubernetesCertsClientKeyAlgo = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesCertsClientKeyAlgo())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withClientKeyAlgo(kubernetesCertsClientKeyAlgo);
        }
        if ((kubernetesCertsClientKeyData = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesCertsClientKeyData())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withClientKeyData(kubernetesCertsClientKeyData);
        }
        if ((kubernetesCertsClientKeyFile = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesCertsClientKeyFile())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withClientKeyFile(kubernetesCertsClientKeyFile);
        }
        if ((kubernetesCertsClientKeyPassphrase = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesCertsClientKeyPassphrase())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withClientKeyPassphrase(kubernetesCertsClientKeyPassphrase);
        }
        if ((kubernetesConnectionTimeout = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesConnectionTimeout())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withConnectionTimeout(Integer.parseInt(kubernetesConnectionTimeout));
        }
        if ((kubernetesKeystoreFile = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesKeystoreFile())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withKeyStoreFile(kubernetesKeystoreFile);
        }
        if ((kubernetesKeystorePassphrase = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesKeystorePassphrase())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withKeyStorePassphrase(kubernetesKeystorePassphrase);
        }
        if ((kubernetesLoggingInterval = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesLoggingInterval())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withLoggingInterval(Integer.parseInt(kubernetesLoggingInterval));
        }
        if ((kubernetesMain = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesMain())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withMasterUrl(kubernetesMain);
        }
        if ((kubernetesNamespace = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesNamespace())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withNamespace(kubernetesNamespace);
        }
        if ((kubernetesRequestTimeout = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesRequestTimeout())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withRequestTimeout(Integer.parseInt(kubernetesRequestTimeout));
        }
        if ((kubernetesRollingTimeout = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesRollingTimeout())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withRollingTimeout(Long.parseLong(kubernetesRollingTimeout));
        }
        if ((kubernetesScaleTimeout = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesScaleTimeout())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withScaleTimeout(Long.parseLong(kubernetesScaleTimeout));
        }
        if ((kubernetesTlsVersions = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesTlsVersions())) != null) {
            String[] split = kubernetesTlsVersions.split(",");
            TlsVersion[] vers = new TlsVersion[split.length];
            for (int i = 0; i < split.length; ++i) {
                vers[i] = TlsVersion.forJavaName((String)split[i]);
            }
            builder.withTlsVersions(vers);
        }
        if ((kubernetesTrustCertificates = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesTrustCertificates())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withTrustCerts(Boolean.parseBoolean(kubernetesTrustCertificates));
        }
        if ((kubernetesTruststoreFile = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesTruststoreFile())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withTrustStoreFile(kubernetesTruststoreFile);
        }
        if ((kubernetesTruststorePassphrase = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesTruststorePassphrase())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withTrustStorePassphrase(kubernetesTruststorePassphrase);
        }
        if ((kubernetesUserAgent = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesUserAgent())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withUserAgent(kubernetesUserAgent);
        }
        if ((kubernetesWatchReconnectInterval = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesWatchReconnectInterval())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withWatchReconnectInterval(Integer.parseInt(kubernetesWatchReconnectInterval));
        }
        if ((kubernetesWatchReconnectLimit = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesWatchReconnectLimit())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withWatchReconnectLimit(Integer.parseInt(kubernetesWatchReconnectLimit));
        }
        if ((kubernetesWebsocketPingInterval = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesWebsocketPingInterval())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withWebsocketPingInterval(Long.parseLong(kubernetesWebsocketPingInterval));
        }
        if ((kubernetesWebsocketTimeout = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesWebsocketTimeout())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withWebsocketTimeout(Long.parseLong(kubernetesWebsocketTimeout));
        }
        if ((noProxy = OpenShiftAccessInterfaceImpl.trimToNull(config.getNoProxy())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withNoProxy(noProxy.split(","));
        }
        if ((proxyPassword = OpenShiftAccessInterfaceImpl.trimToNull(config.getProxyPassword())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withProxyPassword(proxyPassword);
        }
        if ((proxyUsername = OpenShiftAccessInterfaceImpl.trimToNull(config.getProxyUsername())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withProxyUsername(proxyUsername);
        }
        if ((kubernetesOapiVersion = OpenShiftAccessInterfaceImpl.trimToNull(config.getKubernetesOapiVersion())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withOapiVersion(kubernetesOapiVersion);
        }
        if ((openshiftBuildTimeout = OpenShiftAccessInterfaceImpl.trimToNull(config.getOpenshiftBuildTimeout())) != null) {
            builder = (OpenShiftConfigBuilder)builder.withBuildTimeout(Long.parseLong(openshiftBuildTimeout));
        }
        if ((openshiftUrl = OpenShiftAccessInterfaceImpl.trimToNull(config.getOpenshiftUrl())) != null) {
            if (OpenShiftAccessInterfaceImpl.isRootUrl(openshiftUrl)) {
                openshiftUrl = URLUtils.join((String[])new String[]{openshiftUrl, "oapi", builder.getOapiVersion()});
            }
            builder = (OpenShiftConfigBuilder)builder.withOpenShiftUrl(openshiftUrl);
        } else {
            builder.withOpenShiftUrl(URLUtils.join((String[])new String[]{builder.getMasterUrl(), "oapi", builder.getOapiVersion()}));
        }
        return builder.build();
    }

    private static String trimToNull(String s) {
        if (s != null && (s = s.trim()).isEmpty()) {
            s = null;
        }
        return s;
    }

    private static boolean isRootUrl(String url) {
        try {
            String path = new URL(url).getPath();
            return "".equals(path) || "/".equals(path);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public void dispose() {
        this.clientMap.values().forEach(OpenShiftClient::dispose);
    }
}

